/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.xml.editor;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.gui.LimeTextField;
import com.limegroup.gnutella.gui.xml.ComboBoxValue;
import com.limegroup.gnutella.gui.xml.editor.AbstractMetaEditorPanel;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.limewire.util.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetaEditorPanel
extends AbstractMetaEditorPanel {
    private Map<String, JComponent> nameToComponent;
    private Map<String, NameValue<String>> nameToUneditedField;
    protected final FileDesc[] fds;
    protected final LimeXMLDocument document;
    protected final LimeXMLSchema schema;
    private static final Insets leftInsetsLabel = new Insets(5, 3, 0, 2);
    private static final Insets rightInsetsLabel = new Insets(5, 15, 0, 2);
    private static final Insets leftInsetsComponent = new Insets(0, 3, 2, 2);
    private static final Insets rightInsetsComponent = new Insets(0, 15, 2, 2);

    public MetaEditorPanel(FileDesc[] fds, LimeXMLSchema schema, LimeXMLDocument document) {
        this.fds = fds;
        this.schema = schema;
        this.document = document;
        this.nameToComponent = new HashMap<String, JComponent>();
        this.nameToUneditedField = new HashMap<String, NameValue<String>>();
        this.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        this.initWithDocumentFields();
    }

    public FileDesc[] getFileDesc() {
        return this.fds;
    }

    public LimeXMLDocument getDocument() {
        return this.document;
    }

    public LimeXMLSchema getSchema() {
        return this.schema;
    }

    public String getValue(String name) {
        return this.document != null ? this.document.getValue(name) : null;
    }

    public JLabel createLabelAndAdd(String text, int gridx, int gridy, GridBagConstraints gbc, Location loc) {
        JLabel label = new JLabel(text);
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = loc == Location.LEFT ? leftInsetsLabel : rightInsetsLabel;
        this.add((Component)label, gbc);
        return label;
    }

    public LimeTextField createTextField(int textLength, int gridx, int gridy, int gridWidth, GridBagConstraints gbc, Location loc, String name) {
        LimeTextField textField = new LimeTextField(textLength);
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = gridWidth;
        gbc.weightx = 1.0;
        gbc.insets = loc == Location.LEFT ? leftInsetsComponent : rightInsetsComponent;
        this.add((Component)textField, gbc);
        this.addComponent(name, textField);
        return textField;
    }

    public JComboBox createComboBox(int gridx, int gridy, GridBagConstraints gbc, Location loc, String name) {
        JComboBox box = new JComboBox();
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.insets = loc == Location.LEFT ? leftInsetsComponent : rightInsetsComponent;
        this.add(box, gbc);
        this.addComponent(name, box);
        return box;
    }

    public void addComponent(String name, JComponent component) {
        this.addComponent(name, null, component);
    }

    public void addComponent(String name, JCheckBox checkbox, JComponent component) {
        this.nameToComponent.put(name, component);
    }

    public JComponent getComponent(String name) {
        return this.nameToComponent.get(name);
    }

    public Iterable<String> getComponentIterator() {
        return this.nameToComponent.keySet();
    }

    public Iterable<NameValue<String>> getUneditedFieldsIterator() {
        return this.nameToUneditedField.values();
    }

    public void reset() {
        for (String name : this.getComponentIterator()) {
            JComponent comp = this.getComponent(name);
            if (comp instanceof JTextComponent) {
                ((JTextComponent)comp).setText("");
                continue;
            }
            if (!(comp instanceof JComboBox)) continue;
            ((JComboBox)comp).setSelectedIndex(0);
        }
    }

    protected void initFields() {
        for (String name : this.getComponentIterator()) {
            String value = this.getValue(name);
            JComponent comp = this.getComponent(name);
            if (comp instanceof JTextComponent) {
                if (value == null) continue;
                ((JTextComponent)comp).setText(value);
                if (!(comp instanceof JTextArea)) continue;
                ((JTextArea)comp).setCaretPosition(0);
                continue;
            }
            if (!(comp instanceof JComboBox)) continue;
            JComboBox box = (JComboBox)comp;
            for (SchemaFieldInfo infoField : this.getSchema().getEnumerationFields()) {
                ComboBoxValue combVal;
                String currField = infoField.getCanonicalizedFieldName();
                if (!currField.equals(name)) continue;
                ArrayList<ComboBoxValue> values = new ArrayList<ComboBoxValue>();
                values.add(0, new ComboBoxValue());
                this.addEnums(infoField.getEnumerationList(), values);
                int index = 0;
                if (value != null && !value.equals("") && !values.contains(combVal = new ComboBoxValue(value))) {
                    values.add(combVal);
                }
                if (name.indexOf("__licensetype__") >= 0 && value != null && !value.equals("creativecommons.org/licenses/")) {
                    values.remove(new ComboBoxValue("creativecommons.org/licenses/"));
                }
                Object[] arr = values.toArray(new Object[0]);
                Arrays.sort(arr);
                if (value != null && !value.equals("")) {
                    index = Arrays.asList(arr).indexOf(new ComboBoxValue(value));
                }
                box.setModel(new DefaultComboBoxModel<Object>(arr));
                box.setSelectedIndex(index);
            }
        }
    }

    @Override
    public List<NameValue<String>> getInput() {
        ArrayList<NameValue<String>> nameValueList = new ArrayList<NameValue<String>>();
        for (NameValue<String> nv : this.getUneditedFieldsIterator()) {
            nameValueList.add(nv);
        }
        for (String name : this.getComponentIterator()) {
            String cbvalue;
            JComboBox box;
            ComboBoxValue cbv;
            JComponent comp = this.getComponent(name);
            String value = null;
            if (comp instanceof JTextComponent) {
                value = ((JTextComponent)comp).getText().trim();
            } else if (comp instanceof JComboBox && (cbv = (ComboBoxValue)(box = (JComboBox)comp).getSelectedItem()) != null && (cbvalue = cbv.getValue()) != null) {
                value = cbvalue.trim();
            }
            if (value == null) continue;
            nameValueList.add(new NameValue<String>(name, value));
        }
        return nameValueList;
    }

    protected void addEnums(List<? extends NameValue<String>> nameValues, List<? super ComboBoxValue> comboValues) {
        for (NameValue<String> nameValue : nameValues) {
            comboValues.add(new ComboBoxValue(nameValue));
        }
    }

    private void initWithDocumentFields() {
        if (this.document != null) {
            for (Map.Entry<String, String> entry : this.document.getNameValueSet()) {
                String name = entry.getKey();
                this.nameToUneditedField.put(name, new NameValue<String>(name, entry.getValue()));
            }
        }
    }

    @Override
    public boolean checkInput() {
        for (String name : this.getComponentIterator()) {
            String cbvalue;
            JComboBox box;
            ComboBoxValue cbv;
            JComponent comp = this.getComponent(name);
            String value = null;
            if (comp instanceof JTextComponent) {
                value = ((JTextComponent)comp).getText().trim();
            } else if (comp instanceof JComboBox && (cbv = (ComboBoxValue)(box = (JComboBox)comp).getSelectedItem()) != null && (cbvalue = cbv.getValue()) != null) {
                value = cbvalue.trim();
            }
            NameValue<String> nv = this.nameToUneditedField.get(name);
            if (value != null && value.length() > 0 && nv != null) {
                if (value.equals(nv.getValue())) continue;
                return true;
            }
            if (value != null && value.length() > 0 && nv == null) {
                return true;
            }
            if (!(value != null && value.length() != 0 || nv != null && nv.getValue() != null && nv.getValue().length() != 0)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Location {
        LEFT,
        RIGHT;

    }
}

