/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.util.Properties;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkUtils;

public abstract class DefaultHeaders
extends Properties {
    private static final String QUERY_ROUTING_VERSION = "0.1";

    protected DefaultHeaders(String remoteIP, IpPort localIp) {
        if (NetworkUtils.isValidIpPort(localIp)) {
            this.put("Listen-IP", localIp.getAddress() + ":" + localIp.getPort());
        }
        if (remoteIP != null) {
            this.put("Remote-IP", remoteIP);
        }
        DefaultHeaders.addCommonHeaders(this);
    }

    private static void addCommonHeaders(Properties props) {
        props.put("X-Query-Routing", QUERY_ROUTING_VERSION);
        props.put("User-Agent", LimeWireUtils.getHttpServer());
        props.put("GGEP", "0.5");
        props.put("X-Guess", QUERY_ROUTING_VERSION);
        props.put("Vendor-Message", "0.2");
        props.put("X-Requeries", "false");
        props.put("X-Degree", Integer.toString(ConnectionSettings.NUM_CONNECTIONS.getValue()));
        props.put("X-Ultrapeer-Query-Routing", QUERY_ROUTING_VERSION);
        props.put("X-Max-TTL", "3");
        props.put("X-Dynamic-Querying", QUERY_ROUTING_VERSION);
        props.put("X-Locale-Pref", ApplicationSettings.LANGUAGE.getValue());
        if (ConnectionSettings.ACCEPT_DEFLATE.getValue()) {
            props.put(HeaderNames.ACCEPT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        props.put("Pong-Caching", QUERY_ROUTING_VERSION);
    }
}

