/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.handshaking;

import com.limegroup.gnutella.handshaking.DefaultHandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.HandshakeServices;
import com.limegroup.gnutella.handshaking.HandshakeStatus;
import com.limegroup.gnutella.handshaking.HeaderNames;
import com.limegroup.gnutella.handshaking.HeadersFactory;
import java.util.Properties;
import org.limewire.io.IpPort;

public class UltrapeerHandshakeResponder
extends DefaultHandshakeResponder {
    private final HeadersFactory headersFactory;
    private final HandshakeServices handshakeServices;

    UltrapeerHandshakeResponder(String host, HeadersFactory headersFactory, HandshakeServices handshakeServices) {
        super(host);
        this.handshakeServices = handshakeServices;
        this.headersFactory = headersFactory;
    }

    protected HandshakeResponse respondToOutgoing(HandshakeResponse response) {
        HandshakeStatus status = this.handshakeServices.getHandshakeStatusForResponse(response);
        if (!status.isAcceptable()) {
            return HandshakeResponse.createRejectOutgoingResponse(status);
        }
        Properties ret = new Properties();
        if (response.hasLeafGuidance() && this.handshakeServices.isLeafDemotionAllowed() && response.isGoodUltrapeer()) {
            ret.put("X-Ultrapeer", "False");
        }
        if (response.isDeflateAccepted()) {
            ret.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptOutgoingResponse(ret);
    }

    protected HandshakeResponse respondToIncoming(HandshakeResponse response) {
        if (response.isCrawler()) {
            return HandshakeResponse.createCrawlerResponse(this.handshakeServices);
        }
        Properties ret = this.headersFactory.createUltrapeerHeaders(this.getRemoteIP());
        IpPort localIp = this.handshakeServices.getLocalIpPort();
        ret.put("Listen-IP", localIp.getAddress() + ":" + localIp.getPort());
        HandshakeStatus status = this.reject(response, ret);
        if (!status.isAcceptable()) {
            return HandshakeResponse.createUltrapeerRejectIncomingResponse(response, status, this.handshakeServices);
        }
        if (response.isDeflateAccepted()) {
            ret.put(HeaderNames.CONTENT_ENCODING, HeaderNames.DEFLATE_VALUE);
        }
        return HandshakeResponse.createAcceptIncomingResponse(response, ret, this.handshakeServices);
    }

    private HandshakeStatus reject(HandshakeResponse response, Properties ret) {
        HandshakeStatus leafStatus = this.handshakeServices.getHandshakeStatusForResponseAsLeaf(response);
        boolean allowedAsLeaf = leafStatus.isAcceptable();
        if (response.isLeaf()) {
            return leafStatus;
        }
        boolean supernodeNeeded = this.handshakeServices.isUltrapeerNeeded();
        if (allowedAsLeaf && !supernodeNeeded) {
            ret.put("X-Ultrapeer-Needed", Boolean.FALSE.toString());
            return HandshakeStatus.OK;
        }
        HandshakeStatus upStatus = this.handshakeServices.getHandshakeStatusForResponse(response);
        boolean allowedAsUltrapeer = upStatus.isAcceptable();
        if (allowedAsUltrapeer) {
            ret.put("X-Ultrapeer-Needed", Boolean.TRUE.toString());
            return upStatus;
        }
        if (!allowedAsLeaf) {
            return leafStatus;
        }
        return upStatus;
    }
}

