/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocation;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.limewire.collection.MultiRRIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AltLocTracker {
    private Set<DirectAltLoc> writtenLocs = new HashSet<DirectAltLoc>();
    private Set<PushAltLoc> writtenPushLocs = new HashSet<PushAltLoc>();
    private static final int MAX_LOCATIONS = 10;
    private static final int MAX_PUSH_LOCATIONS = 5;
    private int fwtVersion = 0;
    private final URN urn;
    private boolean wantsFAlts;

    public AltLocTracker(URN urn) {
        if (urn == null) {
            throw new IllegalArgumentException();
        }
        this.urn = urn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<DirectAltLoc> getNextSetOfAltsToSend(AltLocManager altLocManager) {
        AlternateLocationCollection<DirectAltLoc> coll = altLocManager.getDirect(this.urn);
        HashSet<DirectAltLoc> ret = null;
        long now = System.currentTimeMillis();
        AlternateLocationCollection<DirectAltLoc> alternateLocationCollection = coll;
        synchronized (alternateLocationCollection) {
            Iterator<DirectAltLoc> iter = coll.iterator();
            int i = 0;
            while (iter.hasNext() && i < 10) {
                DirectAltLoc al = iter.next();
                if (this.writtenLocs.contains(al)) continue;
                if (al.canBeSent(1)) {
                    this.writtenLocs.add(al);
                    if (ret == null) {
                        ret = new HashSet<DirectAltLoc>();
                    }
                    ret.add(al);
                    ++i;
                    al.send(now, 1);
                    continue;
                }
                if (al.canBeSentAny()) continue;
                iter.remove();
            }
        }
        if (ret == null) {
            return Collections.emptySet();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PushAltLoc> getNextSetOfPushAltsToSend(AltLocManager altLocManager) {
        if (!this.wantsFAlts) {
            return Collections.emptySet();
        }
        AlternateLocationCollection<PushAltLoc> fwt = altLocManager.getPushFWT(this.urn);
        AlternateLocationCollection<Object> push = this.fwtVersion > 0 ? AlternateLocationCollection.getEmptyCollection() : altLocManager.getPushNoFWT(this.urn);
        HashSet<PushAltLoc> ret = null;
        long now = System.currentTimeMillis();
        AlternateLocationCollection<Object> alternateLocationCollection = push;
        synchronized (alternateLocationCollection) {
            AlternateLocationCollection<PushAltLoc> alternateLocationCollection2 = fwt;
            synchronized (alternateLocationCollection2) {
                MultiRRIterator<Object> iter = new MultiRRIterator<Object>((Iterator<Object>)fwt.iterator(), push.iterator());
                int i = 0;
                while (iter.hasNext() && i < 5) {
                    PushAltLoc al = (PushAltLoc)iter.next();
                    if (this.writtenPushLocs.contains(al)) continue;
                    if (al.getPushAddress().getProxies().isEmpty()) {
                        iter.remove();
                        continue;
                    }
                    if (al.canBeSent(1)) {
                        al.send(now, 1);
                        this.writtenPushLocs.add(al);
                        if (ret == null) {
                            ret = new HashSet<PushAltLoc>();
                        }
                        ret.add(al);
                        ++i;
                        continue;
                    }
                    if (al.canBeSentAny()) continue;
                    iter.remove();
                }
            }
        }
        if (ret == null) {
            return Collections.emptySet();
        }
        return ret;
    }

    public void addLocation(AlternateLocation al) {
        if (al instanceof DirectAltLoc) {
            this.writtenLocs.add((DirectAltLoc)al);
        } else {
            this.writtenPushLocs.add((PushAltLoc)al);
        }
    }

    public boolean wantsFAlts() {
        return this.wantsFAlts;
    }

    public void setWantsFAlts(boolean wantsFAlts) {
        this.wantsFAlts = wantsFAlts;
    }

    public URN getUrn() {
        return this.urn;
    }

    public int getFwtVersion() {
        return this.fwtVersion;
    }

    public void setFwtVersion(int fwtVersion) {
        this.fwtVersion = fwtVersion;
    }
}

