/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.AbortableHttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.HttpParams;
import org.limewire.collection.Cancellable;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.http.httpclient.HttpClientUtils;
import org.limewire.http.httpclient.LimeHttpClient;
import org.limewire.nio.observer.Shutdownable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DefaultHttpExecutor
implements HttpExecutor {
    private static final ExecutorService POOL = ExecutorsHelper.newThreadPool("HttpClient pool");
    private final Provider<LimeHttpClient> clientProvider;

    @Inject
    public DefaultHttpExecutor(Provider<LimeHttpClient> clientProvider) {
        this.clientProvider = clientProvider;
    }

    @Override
    public Shutdownable execute(HttpUriRequest method, HttpParams params, HttpClientListener listener) {
        return this.execute(method, params, listener, POOL);
    }

    @Override
    public Shutdownable execute(final HttpUriRequest method, final HttpParams params, final HttpClientListener listener, ExecutorService executor) {
        Runnable r = new Runnable(){

            public void run() {
                DefaultHttpExecutor.this.performRequest(method, params, listener);
            }
        };
        executor.execute(r);
        return new Aborter(method);
    }

    @Override
    public void releaseResources(HttpResponse response) {
        HttpClientUtils.releaseConnection(response);
    }

    @Override
    public Shutdownable executeAny(HttpClientListener listener, ExecutorService executor, Iterable<? extends HttpUriRequest> methods, HttpParams params, Cancellable canceller) {
        MultiRequestor r = new MultiRequestor(listener, methods, params, canceller);
        executor.execute(r);
        return r;
    }

    private boolean performRequest(HttpUriRequest method, HttpParams params, HttpClientListener listener) {
        HttpResponse response;
        if (!listener.allowRequest(method)) {
            return false;
        }
        LimeHttpClient client = this.clientProvider.get();
        if (params != null) {
            client.setParams(params);
        }
        try {
            response = client.execute(method);
        }
        catch (IOException failed) {
            return !listener.requestFailed(method, null, failed);
        }
        catch (HttpException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            return !listener.requestFailed(method, null, ioe);
        }
        catch (IllegalStateException ise) {
            IOException ioe = new IOException();
            ioe.initCause(ise);
            return !listener.requestFailed(method, null, ioe);
        }
        return !listener.requestComplete(method, response);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MultiRequestor
    implements Runnable,
    Shutdownable {
        private boolean shutdown;
        private HttpUriRequest currentMethod;
        private final Iterable<? extends HttpUriRequest> methods;
        private final HttpClientListener listener;
        private HttpParams params;
        private final Cancellable canceller;

        MultiRequestor(HttpClientListener listener, Iterable<? extends HttpUriRequest> methods, HttpParams params, Cancellable canceller) {
            this.methods = methods;
            this.listener = listener;
            this.params = params;
            this.canceller = canceller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (HttpUriRequest httpUriRequest : this.methods) {
                MultiRequestor multiRequestor = this;
                synchronized (multiRequestor) {
                    if (this.shutdown) {
                        return;
                    }
                    this.currentMethod = httpUriRequest;
                }
                if (this.canceller.isCancelled()) {
                    return;
                }
                if (!DefaultHttpExecutor.this.performRequest(httpUriRequest, this.params, this.listener)) continue;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void shutdown() {
            HttpUriRequest m;
            MultiRequestor multiRequestor = this;
            synchronized (multiRequestor) {
                this.shutdown = true;
                m = this.currentMethod;
            }
            if (m instanceof AbortableHttpRequest) {
                ((AbortableHttpRequest)((Object)m)).abort();
            }
        }
    }

    private class Aborter
    implements Shutdownable {
        private final AbortableHttpRequest toAbort;

        Aborter(HttpUriRequest toAbort) {
            this.toAbort = toAbort instanceof AbortableHttpRequest ? (AbortableHttpRequest)((Object)toAbort) : null;
        }

        public void shutdown() {
            if (this.toAbort != null) {
                this.toAbort.abort();
            }
        }
    }
}

