/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.http.WriteHeadersIOState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.http.Header;
import org.limewire.statistic.Statistic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleWriteHeaderState
extends WriteHeadersIOState {
    private final String connectLine;
    private final List<? extends Header> headers;

    public SimpleWriteHeaderState(String connectLine, List<? extends Header> headers, Statistic stat) {
        super(stat);
        this.connectLine = connectLine;
        this.headers = headers;
    }

    @Override
    protected ByteBuffer createOutgoingData() throws IOException {
        StringBuilder sb = new StringBuilder(this.connectLine.length() + this.headers.size() * 25);
        sb.append(this.connectLine).append("\r\n");
        for (Header header : this.headers) {
            sb.append(HTTPUtils.createHeader(header.getName(), header.getValue()));
        }
        sb.append("\r\n");
        return ByteBuffer.wrap(sb.toString().getBytes());
    }

    @Override
    protected void processWrittenHeaders() throws IOException {
    }
}

