/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.library;

import com.limegroup.gnutella.FileDesc;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public class SharingUtils {
    public static final File PROGRAM_SHARE;
    public static final File PREFERENCE_SHARE;
    public static final File APPLICATION_SPECIAL_SHARE;

    public static boolean isFilePhysicallyShareable(File file) {
        if (file == null || !file.exists() || file.isDirectory() || !file.canRead() || file.isHidden()) {
            return false;
        }
        long fileLength = file.length();
        return fileLength > 0L && fileLength <= 0xFFFFFFFFFFL;
    }

    public static boolean isSensitiveDirectory(File folder) {
        if (folder == null) {
            return false;
        }
        String userHome = System.getProperty("user.home");
        if (folder.equals(new File(userHome))) {
            return true;
        }
        String userHomeShortDir = userHome.substring(userHome.lastIndexOf(File.separator) + 1);
        String[] sensitive = OSUtils.isWindowsVista() ? new String[]{"Documents and Settings", userHomeShortDir + File.separator + "Documents", "Desktop", "Program Files", "Windows", "WINNT", "Users", "Local Settings", "Application Data", "Temp", "Temporary Internet Files"} : (OSUtils.isWindows() ? new String[]{"Documents and Settings", "My Documents", "Desktop", "Program Files", "Windows", "WINNT", "Users", "Local Settings", "Application Data", "Temp", "Temporary Internet Files"} : (OSUtils.isMacOSX() ? new String[]{"Users", "System", "System Folder", "Previous Systems", "private", "Volumes", "Desktop", "Applications", "Applications (Mac OS 9)", "Network"} : (OSUtils.isPOSIX() ? new String[]{"bin", "boot", "dev", "etc", "home", "mnt", "opt", "proc", "root", "sbin", "usr", "var"} : new String[]{})));
        String folderPath = folder.getPath();
        for (String name : sensitive) {
            if (!folderPath.endsWith(File.separator + name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isForcedShare(FileDesc desc) {
        return SharingUtils.isForcedShare(desc.getFile());
    }

    public static boolean isForcedShare(File file) {
        File parent = file.getParentFile();
        return parent != null && SharingUtils.isForcedShareDirectory(parent);
    }

    public static boolean isApplicationSpecialShare(File file) {
        File parent = file.getParentFile();
        return parent != null && SharingUtils.isApplicationSpecialShareDirectory(parent);
    }

    public static boolean isForcedShareDirectory(File f) {
        return f.equals(PROGRAM_SHARE) || f.equals(PREFERENCE_SHARE);
    }

    public static boolean isApplicationSpecialShareDirectory(File directory) {
        return directory.equals(APPLICATION_SPECIAL_SHARE);
    }

    public static boolean isFolderBanned(File folder) {
        String parent;
        String name;
        File[] faRoots = File.listRoots();
        if (faRoots != null && faRoots.length > 0) {
            for (int i = 0; i < faRoots.length; ++i) {
                if (!folder.equals(faRoots[i])) continue;
                return true;
            }
        }
        if ((name = folder.getName().toLowerCase(Locale.US)).equals("cookies")) {
            return true;
        }
        return name.equals("low") && (parent = folder.getParent()) != null && parent.toLowerCase(Locale.US).equals("cookies");
    }

    static {
        File forceShare = new File(".", ".NetworkShare").getAbsoluteFile();
        try {
            forceShare = FileUtils.getCanonicalFile(forceShare);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        PROGRAM_SHARE = forceShare;
        forceShare = new File(CommonUtils.getUserSettingsDir(), ".NetworkShare").getAbsoluteFile();
        try {
            forceShare = FileUtils.getCanonicalFile(forceShare);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        PREFERENCE_SHARE = forceShare;
        forceShare = new File(CommonUtils.getUserSettingsDir(), ".AppSpecialShare").getAbsoluteFile();
        forceShare.mkdir();
        try {
            forceShare = FileUtils.getCanonicalFile(forceShare);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        APPLICATION_SPECIAL_SHARE = forceShare;
    }
}

