/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messagehandlers;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messagehandlers.MessageHandler;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.LimeACKVendorMessage;
import com.limegroup.gnutella.settings.MessageSettings;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.limewire.lifecycle.Service;
import org.limewire.security.SecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class LimeACKHandler
implements MessageHandler,
Service {
    private static final long TIMED_GUID_LIFETIME = 25000L;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<MessageRouter> messageRouter;
    private final Provider<UDPService> udpService;
    private final Map<GUID.TimedGUID, QueryResponseBundle> _outOfBandReplies = new Hashtable<GUID.TimedGUID, QueryResponseBundle>();

    @Inject
    public LimeACKHandler(@Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, Provider<MessageRouter> messageRouter, Provider<UDPService> udpService) {
        this.backgroundExecutor = backgroundExecutor;
        this.messageRouter = messageRouter;
        this.udpService = udpService;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void start() {
        this.backgroundExecutor.scheduleAtFixedRate(new Expirer(), 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
    }

    @Override
    public void handleMessage(Message msg, InetSocketAddress addr, ReplyHandler handler) {
        LimeACKVendorMessage ack = (LimeACKVendorMessage)msg;
        GUID.TimedGUID refGUID = new GUID.TimedGUID(new GUID(ack.getGUID()), 25000L);
        QueryResponseBundle bundle = this._outOfBandReplies.remove(refGUID);
        SecurityToken securityToken = ack.getSecurityToken();
        if (bundle != null && ack.getNumResults() > 0) {
            Iterable<QueryReply> iterable;
            final InetAddress iaddr = addr.getAddress();
            final int port = addr.getPort();
            if (ack.getNumResults() < bundle._responses.length) {
                Response[] desired = new Response[ack.getNumResults()];
                System.arraycopy(bundle._responses, 0, desired, 0, desired.length);
                iterable = this.messageRouter.get().responsesToQueryReplies(desired, bundle._query, 1, securityToken);
            } else {
                iterable = this.messageRouter.get().responsesToQueryReplies(bundle._responses, bundle._query, 1, securityToken);
            }
            int i = 0;
            for (final QueryReply queryReply : iterable) {
                this.backgroundExecutor.schedule(new Runnable(){

                    public void run() {
                        ((UDPService)LimeACKHandler.this.udpService.get()).send(queryReply, iaddr, port);
                    }
                }, (long)(i++ * 200), TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bufferResponsesForLaterDelivery(QueryRequest query, Response[] resps) {
        Map<GUID.TimedGUID, QueryResponseBundle> map = this._outOfBandReplies;
        synchronized (map) {
            if (this._outOfBandReplies.size() < MessageSettings.MAX_BUFFERED_OOB_REPLIES.getValue()) {
                GUID.TimedGUID tGUID = new GUID.TimedGUID(new GUID(query.getGUID()), 25000L);
                this._outOfBandReplies.put(tGUID, new QueryResponseBundle(query, resps));
                return true;
            }
            return false;
        }
    }

    private class Expirer
    implements Runnable {
        private Expirer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            HashSet<GUID.TimedGUID> toRemove = new HashSet<GUID.TimedGUID>();
            Map map = LimeACKHandler.this._outOfBandReplies;
            synchronized (map) {
                long now = System.currentTimeMillis();
                for (GUID.TimedGUID currQB : LimeACKHandler.this._outOfBandReplies.keySet()) {
                    if (currQB == null || !currQB.shouldExpire(now)) continue;
                    toRemove.add(currQB);
                }
                for (GUID.TimedGUID next : toRemove) {
                    LimeACKHandler.this._outOfBandReplies.remove(next);
                }
            }
        }
    }

    private static class QueryResponseBundle {
        public final QueryRequest _query;
        public final Response[] _responses;

        public QueryResponseBundle(QueryRequest query, Response[] responses) {
            this._query = query;
            this._responses = responses;
        }
    }
}

