/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.Message;
import java.io.IOException;
import java.io.OutputStream;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMessage
implements Message {
    private byte[] guid;
    private final byte func;
    private byte ttl;
    private byte hops;
    private int length;
    private int priority = 0;
    private final long creationTime = System.currentTimeMillis();
    private final Message.Network network;

    public static byte[] makeGuid() {
        return GUID.makeGuid();
    }

    protected void repOk() {
        assert (this.guid.length == 16);
        assert (this.func == 0 || this.func == 1 || this.func == 64 || this.func == -128 || this.func == -127 || this.func == 49 || this.func == 50 || this.func == 65) : "Bad function code";
        assert (this.ttl >= 0) : "Negative TTL: " + this.ttl;
        assert (this.hops >= 0) : "Negative hops: " + this.hops;
        assert (this.length >= 0) : "Negative length: " + this.length;
    }

    protected AbstractMessage(byte func, byte ttl, int length) {
        this(func, ttl, length, Message.Network.UNKNOWN);
    }

    protected AbstractMessage(byte func, byte ttl, int length, Message.Network network) {
        this(AbstractMessage.makeGuid(), func, ttl, 0, length, network);
    }

    protected AbstractMessage(byte[] guid, byte func, byte ttl, byte hops, int length) {
        this(guid, func, ttl, hops, length, Message.Network.UNKNOWN);
    }

    protected AbstractMessage(byte[] guid, byte func, byte ttl, byte hops, int length, Message.Network network) {
        if (guid.length != 16) {
            throw new IllegalArgumentException("invalid guid length: " + guid.length);
        }
        this.guid = guid;
        this.func = func;
        this.ttl = ttl;
        this.hops = hops;
        this.length = length;
        this.network = network;
    }

    @Override
    public void writeQuickly(OutputStream out) throws IOException {
        out.write(this.guid, 0, this.guid.length);
        out.write(this.func);
        out.write(this.ttl);
        out.write(this.hops);
        ByteUtils.int2leb(this.length, out);
        this.writePayload(out);
    }

    @Override
    public void write(OutputStream out, byte[] buf) throws IOException {
        System.arraycopy(this.guid, 0, buf, 0, this.guid.length);
        buf[16] = this.func;
        buf[17] = this.ttl;
        buf[18] = this.hops;
        ByteUtils.int2leb(this.length, buf, 19);
        out.write(buf);
        this.writePayload(out);
    }

    @Override
    public void write(OutputStream out) throws IOException {
        this.write(out, new byte[23]);
    }

    protected abstract void writePayload(OutputStream var1) throws IOException;

    @Override
    public Message.Network getNetwork() {
        return this.network;
    }

    @Override
    public boolean isMulticast() {
        return this.network == Message.Network.MULTICAST;
    }

    @Override
    public boolean isUDP() {
        return this.network == Message.Network.UDP;
    }

    @Override
    public boolean isTCP() {
        return this.network == Message.Network.TCP;
    }

    @Override
    public boolean isUnknownNetwork() {
        return this.network == Message.Network.UNKNOWN;
    }

    @Override
    public byte[] getGUID() {
        return this.guid;
    }

    @Override
    public byte getFunc() {
        return this.func;
    }

    @Override
    public byte getTTL() {
        return this.ttl;
    }

    @Override
    public void setTTL(byte ttl) throws IllegalArgumentException {
        if (ttl < 0) {
            throw new IllegalArgumentException("invalid TTL: " + ttl);
        }
        this.ttl = ttl;
    }

    protected void setGUID(GUID guid) {
        this.guid = guid.bytes();
    }

    @Override
    public void setHops(byte hops) throws IllegalArgumentException {
        if (hops < 0) {
            throw new IllegalArgumentException("invalid hops: " + hops);
        }
        this.hops = hops;
    }

    @Override
    public byte getHops() {
        return this.hops;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    protected void updateLength(int l) {
        this.length = l;
    }

    @Override
    public int getTotalLength() {
        return 23 + this.length;
    }

    @Override
    public byte hop() {
        this.hops = (byte)(this.hops + 1);
        if (this.ttl > 0) {
            byte by = this.ttl;
            this.ttl = (byte)(by - 1);
            return by;
        }
        return this.ttl;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(Message m) {
        return m.getPriority() - this.getPriority();
    }

    public String toString() {
        return "{guid=" + new GUID(this.guid).toString() + ", ttl=" + this.ttl + ", hops=" + this.hops + ", priority=" + this.getPriority() + "}";
    }

    @Override
    public Class<? extends Message> getHandlerClass() {
        return this.getClass();
    }
}

