/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.settings.SharingSettings;
import java.util.ArrayList;
import org.limewire.collection.IntervalSet;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.util.ByteUtils;

public class IntervalEncoder {
    public static void encode(long size, GGEP g, IntervalSet s) {
        ArrayList<Integer> bytes = new ArrayList<Integer>();
        ArrayList<Integer> shorts = new ArrayList<Integer>();
        ArrayList<Integer> b24 = new ArrayList<Integer>();
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (int i : s.encode(size)) {
            long l = i & 0xFFFFFFFF;
            if (l > 0xFFFFFFL) {
                ints.add(i);
                continue;
            }
            if (l > 65535L) {
                b24.add(i);
                continue;
            }
            if (l > 255L) {
                shorts.add(i);
                continue;
            }
            bytes.add(i);
        }
        byte[] bytesB = new byte[bytes.size()];
        for (int i = 0; i < bytesB.length; ++i) {
            bytesB[i] = (byte)((Integer)bytes.get(i)).intValue();
        }
        byte[] shortsB = new byte[shorts.size() * 2];
        for (int i = 0; i < shorts.size(); ++i) {
            ByteUtils.short2beb(((Integer)shorts.get(i)).shortValue(), shortsB, i * 2);
        }
        byte[] b24B = new byte[b24.size() * 3];
        for (int i = 0; i < b24.size(); ++i) {
            int value = (Integer)b24.get(i);
            b24B[i * 3] = (byte)((value & 0xFF0000) >> 16);
            b24B[i * 3 + 1] = (byte)((value & 0xFF00) >> 8);
            b24B[i * 3 + 2] = (byte)(value & 0xFF);
        }
        byte[] intsB = new byte[ints.size() * 4];
        for (int i = 0; i < ints.size(); ++i) {
            ByteUtils.int2beb((int)((Integer)ints.get(i)), intsB, i * 4);
        }
        int availableSpace = SharingSettings.MAX_PARTIAL_ENCODING_SIZE.getValue();
        availableSpace = IntervalEncoder.addIfSpace(bytesB, g, 1, availableSpace);
        availableSpace = IntervalEncoder.addIfSpace(shortsB, g, 2, availableSpace);
        availableSpace = IntervalEncoder.addIfSpace(b24B, g, 3, availableSpace);
        IntervalEncoder.addIfSpace(intsB, g, 4, availableSpace);
        if (bytes.size() + shorts.size() + b24.size() + ints.size() == 0) {
            g.put("PR0");
        }
    }

    private static int addIfSpace(byte[] toAdd, GGEP ggep, int dataSize, int available) {
        if (toAdd.length == 0 || available <= 0) {
            return available;
        }
        assert (toAdd.length % dataSize == 0);
        if (toAdd.length > available) {
            byte[] tmp = new byte[available - available % dataSize];
            if (tmp.length == 0) {
                return available;
            }
            System.arraycopy(toAdd, 0, tmp, 0, tmp.length);
            toAdd = tmp;
        }
        ggep.put("PR" + dataSize, toAdd);
        return available - toAdd.length;
    }

    public static IntervalSet decode(long size, GGEP ggep) throws BadGGEPPropertyException {
        if (ggep.hasKey("PR0")) {
            return new IntervalSet();
        }
        IntervalSet ret = null;
        for (int i = 1; i <= 4; ++i) {
            byte[] b;
            String key = "PR" + i;
            if (!ggep.hasKey(key) || (b = ggep.get(key)) == null) continue;
            if (ret == null) {
                ret = new IntervalSet();
            }
            if (b.length % i != 0) {
                return null;
            }
            for (int j = 0; j < b.length; j += i) {
                int nodeId = 0;
                for (int k = 0; k < i; ++k) {
                    nodeId <<= 8;
                    nodeId |= b[j + k] & 0xFF;
                }
                ret.decode(size, nodeId);
            }
        }
        return ret;
    }
}

