/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.messages.AbstractMessage;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.DataUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.service.ErrorService;
import org.limewire.util.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingRequestImpl
extends AbstractMessage
implements PingRequest {
    private byte[] payload = null;
    private GGEP _ggep;

    PingRequestImpl(byte[] guid, byte ttl, byte hops) {
        super(guid, (byte)0, ttl, hops, 0);
    }

    PingRequestImpl(byte[] guid, byte ttl, byte hops, byte[] payload) {
        super(guid, (byte)0, ttl, hops, payload.length);
        this.payload = payload;
    }

    PingRequestImpl(byte ttl) {
        super((byte)0, ttl, 0);
        this.addBasicGGEPs();
    }

    PingRequestImpl(byte[] guid, byte ttl) {
        super(guid, (byte)0, ttl, (byte)0, 0);
        this.addBasicGGEPs();
    }

    PingRequestImpl(byte[] guid, byte ttl, List<NameValue<?>> ggeps) {
        super(guid, (byte)0, ttl, (byte)0, 0);
        this.addGGEPs(ggeps);
    }

    @Override
    protected void writePayload(OutputStream out) throws IOException {
        if (this.payload != null && this.payload.length > 0) {
            out.write(this.payload);
        }
    }

    @Override
    public String toString() {
        return "PingRequest(" + super.toString() + ")";
    }

    @Override
    public boolean isHeartbeat() {
        return this.getHops() == 1 && this.getTTL() == 0;
    }

    @Override
    public void addIPRequest() {
        LinkedList l = new LinkedList();
        l.add(new NameValue("IP"));
        this.addGGEPs(l);
    }

    private void addBasicGGEPs() {
        LinkedList<NameValue<String>> l = new LinkedList<NameValue<String>>();
        l.add(new NameValue<String>("LOC", ApplicationSettings.LANGUAGE.getValue()));
        this.addGGEPs(l);
    }

    private void addGGEPs(List<? extends NameValue<?>> ggeps) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (this._ggep == null) {
                this._ggep = new GGEP();
            }
            this._ggep.putAll(ggeps);
            this._ggep.write(baos);
            baos.write(0);
            this.payload = baos.toByteArray();
            this.updateLength(this.payload.length);
        }
        catch (IOException e) {
            ErrorService.error(e);
        }
    }

    @Override
    public String getLocale() {
        if (this.payload != null && this.payload.length > 0) {
            try {
                this.parseGGEP();
                if (this._ggep.hasKey("LOC")) {
                    return this._ggep.getString("LOC");
                }
            }
            catch (BadGGEPBlockException ignored) {
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                // empty catch block
            }
        }
        return ApplicationSettings.DEFAULT_LOCALE.getValue();
    }

    @Override
    public boolean supportsCachedPongs() {
        if (this.payload != null && this.payload.length > 0) {
            try {
                this.parseGGEP();
                return this._ggep.hasKey("SCP");
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public byte[] getSupportsCachedPongData() {
        byte[] ret = null;
        if (this.payload != null && this.payload.length > 0) {
            try {
                this.parseGGEP();
                if (this._ggep.hasKey("SCP")) {
                    ret = DataUtils.EMPTY_BYTE_ARRAY;
                    return this._ggep.getBytes("SCP");
                }
            }
            catch (BadGGEPBlockException ignored) {
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
                // empty catch block
            }
        }
        return ret;
    }

    @Override
    public boolean isQueryKeyRequest() {
        if (this.getTTL() != 0 || this.getHops() != 1) {
            return false;
        }
        if (this.payload != null && this.payload.length > 0) {
            try {
                this.parseGGEP();
                return this._ggep.hasKey("QK");
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean requestsIP() {
        if (this.payload != null && this.payload.length > 0) {
            try {
                this.parseGGEP();
                return this._ggep.hasKey("IP");
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean requestsDHTIPP() {
        if (this.payload != null && this.payload.length > 0) {
            try {
                this.parseGGEP();
                return this._ggep.hasKey("DHTIPP");
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public Class<? extends Message> getHandlerClass() {
        return PingRequest.class;
    }

    private void parseGGEP() throws BadGGEPBlockException {
        if (this._ggep == null) {
            this._ggep = new GGEP(this.payload, 0, null);
        }
    }
}

