/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.FeatureSearchData;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import org.limewire.collection.Comparators;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapabilitiesVMImpl
extends AbstractVendorMessage
implements CapabilitiesVM {
    private final Map<byte[], Integer> capabilities;

    CapabilitiesVMImpl(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, F_NULL_VENDOR_ID, 10, version, payload, network);
        this.capabilities = new TreeMap<byte[], Integer>(new Comparators.ByteArrayComparator());
        try {
            int i;
            ByteArrayInputStream bais = new ByteArrayInputStream(payload);
            int vectorSize = ByteUtils.ushort2int(ByteUtils.leb2short(bais));
            for (i = 0; i < vectorSize; ++i) {
                this.readCapability(bais, false);
            }
            if (bais.available() > 0) {
                vectorSize = ByteUtils.ushort2int(ByteUtils.leb2short(bais));
                for (i = 0; i < vectorSize; ++i) {
                    this.readCapability(bais, true);
                }
            }
        }
        catch (IOException ioe) {
            throw new BadPacketException(ioe);
        }
    }

    CapabilitiesVMImpl(Map<byte[], Integer> _capabilitiesSupported) {
        super(F_NULL_VENDOR_ID, 10, 1, CapabilitiesVMImpl.derivePayload(_capabilitiesSupported));
        this.capabilities = _capabilitiesSupported;
    }

    private static byte[] derivePayload(Map<byte[], Integer> allCapabilities) {
        try {
            TreeMap<byte[], Integer> capsNeedingInt = new TreeMap<byte[], Integer>(new Comparators.ByteArrayComparator());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteUtils.short2leb((short)allCapabilities.size(), out);
            for (Map.Entry<byte[], Integer> entry : allCapabilities.entrySet()) {
                CapabilitiesVMImpl.writeCapability(out, entry.getKey(), entry.getValue(), false);
                if (entry.getValue() <= 65535) continue;
                capsNeedingInt.put(entry.getKey(), entry.getValue());
            }
            if (capsNeedingInt.size() > 0) {
                ByteUtils.short2leb((short)capsNeedingInt.size(), out);
                for (Map.Entry<Object, Integer> entry : capsNeedingInt.entrySet()) {
                    CapabilitiesVMImpl.writeCapability(out, (byte[])entry.getKey(), entry.getValue(), true);
                }
            }
            return out.toByteArray();
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
            return null;
        }
    }

    @Override
    public int supportsCapability(byte[] capabilityName) {
        Integer version = this.capabilities.get(capabilityName);
        if (version == null || version <= -1) {
            return -1;
        }
        return version;
    }

    @Override
    public int supportsTLS() {
        return this.supportsCapability(TLS_SUPPORT_BYTES);
    }

    @Override
    public int supportsFeatureQueries() {
        return this.supportsCapability(FEATURE_SEARCH_BYTES);
    }

    @Override
    public boolean supportsWhatIsNew() {
        return FeatureSearchData.supportsWhatIsNew(this.supportsCapability(FEATURE_SEARCH_BYTES));
    }

    @Override
    public int supportsSIMPP() {
        return this.supportsCapability(SIMPP_BYTES);
    }

    @Override
    public int supportsUpdate() {
        return this.supportsCapability(UPDATE_BYTES);
    }

    @Override
    public int isActiveDHTNode() {
        return this.supportsCapability(DHTManager.DHTMode.ACTIVE.getCapabilityName());
    }

    @Override
    public int isPassiveDHTNode() {
        return this.supportsCapability(DHTManager.DHTMode.PASSIVE.getCapabilityName());
    }

    @Override
    public int isPassiveLeafNode() {
        return this.supportsCapability(DHTManager.DHTMode.PASSIVE_LEAF.getCapabilityName());
    }

    @Override
    public boolean canAcceptIncomingTCP() {
        return this.supportsCapability(INCOMING_TCP_BYTES) != 0;
    }

    @Override
    public boolean canDoFWT() {
        return this.supportsCapability(FWT_SUPPORT_BYTES) != 0;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof CapabilitiesVMImpl) {
            CapabilitiesVMImpl vmp = (CapabilitiesVMImpl)other;
            return ((Object)this.capabilities).equals(vmp.capabilities);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.capabilities).hashCode();
    }

    private void readCapability(InputStream input, boolean allow4ByteVersion) throws IOException {
        int required;
        int n = required = allow4ByteVersion ? 8 : 6;
        if (input.available() < required) {
            throw new IOException("invalid block.");
        }
        byte[] name = new byte[4];
        input.read(name, 0, name.length);
        int version = allow4ByteVersion ? ByteUtils.leb2int(input) : ByteUtils.ushort2int(ByteUtils.leb2short(input));
        this.capabilities.put(name, version);
    }

    static void writeCapability(OutputStream out, byte[] name, int version, boolean allow4ByteVersion) throws IOException {
        out.write(name);
        if (allow4ByteVersion) {
            ByteUtils.int2leb(version, out);
        } else {
            ByteUtils.short2leb((short)version, out);
        }
    }

    @Override
    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
    }

    @Override
    public String toString() {
        return "{CapabilitiesVM:" + super.toString() + "; supporting: " + this.capabilities + "}";
    }
}

