/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.limewire.io.IOUtils;
import org.limewire.mojito.io.MessageInputStream;
import org.limewire.mojito.io.MessageOutputStream;
import org.limewire.mojito.routing.Contact;
import org.limewire.security.MACCalculatorRepositoryManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTContactsMessage
extends AbstractVendorMessage {
    public static final int VERSION = 1;
    private final Collection<? extends Contact> nodes;

    public DHTContactsMessage(Contact node) {
        this(Collections.singleton(node));
    }

    public DHTContactsMessage(Collection<? extends Contact> nodes) {
        super(F_LIME_VENDOR_ID, 33, 1, DHTContactsMessage.derivePayload(nodes));
        this.nodes = nodes;
    }

    public DHTContactsMessage(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network, MACCalculatorRepositoryManager macManager) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 33, version, payload, network);
        ByteArrayInputStream bais = new ByteArrayInputStream(payload);
        MessageInputStream in = new MessageInputStream(bais, macManager);
        try {
            this.nodes = in.readContacts();
        }
        catch (IOException err) {
            throw new BadPacketException(err);
        }
        finally {
            IOUtils.close(in);
        }
    }

    public Collection<? extends Contact> getContacts() {
        return this.nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] derivePayload(Collection<? extends Contact> nodes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MessageOutputStream out = new MessageOutputStream(baos);
        try {
            out.writeContacts(nodes);
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.close(out);
        }
        return baos.toByteArray();
    }
}

