/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.HeadPong;
import com.limegroup.gnutella.messages.vendor.HeadPongFactory;
import com.limegroup.gnutella.messages.vendor.HeadPongImpl;
import com.limegroup.gnutella.messages.vendor.HeadPongRequestor;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.BitNumbers;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.MultiRRIterator;
import org.limewire.io.Connectable;
import org.limewire.io.CountingOutputStream;
import org.limewire.io.GGEP;
import org.limewire.io.IpPort;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class HeadPongFactoryImpl
implements HeadPongFactory {
    private static final Log LOG = LogFactory.getLog(HeadPongFactoryImpl.class);
    private final NetworkManager networkManager;
    private final Provider<UploadManager> uploadManager;
    private final Provider<FileManager> fileManager;
    private final Provider<AltLocManager> altLocManager;
    private final PushEndpointFactory pushEndpointFactory;
    public static final int DEFAULT_PACKET_SIZE = 1380;
    private static int PACKET_SIZE = 1380;
    private final Provider<DownloadManager> downloadManager;

    @Inject
    public HeadPongFactoryImpl(NetworkManager networkManager, Provider<UploadManager> uploadManager, Provider<FileManager> fileManager, Provider<AltLocManager> altLocManager, PushEndpointFactory pushEndpointFactory, Provider<DownloadManager> downloadManager) {
        this.networkManager = networkManager;
        this.uploadManager = uploadManager;
        this.fileManager = fileManager;
        this.altLocManager = altLocManager;
        this.pushEndpointFactory = pushEndpointFactory;
        this.downloadManager = downloadManager;
    }

    @Override
    public HeadPong createFromNetwork(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        return new HeadPongImpl(guid, ttl, hops, version, payload, network, this.pushEndpointFactory);
    }

    @Override
    public HeadPong create(HeadPongRequestor ping) {
        return new HeadPongImpl(new GUID(ping.getGUID()), this.versionFor(ping), this.derivePayload(ping));
    }

    private byte[] writeGGEP(GGEP ggep) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ggep.write(out);
        }
        catch (IOException iox) {
            ErrorService.error(iox);
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addLocations(HeadPongRequestor ping, URN urn, OutputStream out, AtomicReference<BitNumbers> tlsIndexes, int written, boolean includeSize) {
        if (ping.requestsAltlocs()) {
            AlternateLocationCollection<DirectAltLoc> col;
            AlternateLocationCollection<DirectAltLoc> alternateLocationCollection = col = this.altLocManager.get().getDirect(urn);
            synchronized (alternateLocationCollection) {
                try {
                    return !this.writeLocs(out, col.iterator(), tlsIndexes, written, includeSize);
                }
                catch (IOException impossible) {
                    ErrorService.error(impossible);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addPushLocations(HeadPongRequestor ping, URN urn, OutputStream out, boolean includeTLS, int written, boolean includeSize) {
        if (!ping.requestsPushLocs()) {
            return true;
        }
        try {
            boolean FWTOnly = ping.requestsFWTOnlyPushLocs();
            if (FWTOnly) {
                AlternateLocationCollection<PushAltLoc> push;
                AlternateLocationCollection<PushAltLoc> alternateLocationCollection = push = this.altLocManager.get().getPushFWT(urn);
                synchronized (alternateLocationCollection) {
                    return !this.writePushLocs(out, push.iterator(), includeTLS, written, includeSize);
                }
            }
            AlternateLocationCollection<PushAltLoc> push = this.altLocManager.get().getPushNoFWT(urn);
            AlternateLocationCollection<PushAltLoc> fwt = this.altLocManager.get().getPushFWT(urn);
            AlternateLocationCollection<PushAltLoc> alternateLocationCollection = push;
            synchronized (alternateLocationCollection) {
                AlternateLocationCollection<PushAltLoc> alternateLocationCollection2 = fwt;
                synchronized (alternateLocationCollection2) {
                    return !this.writePushLocs(out, new MultiRRIterator<PushAltLoc>(push.iterator(), fwt.iterator()), includeTLS, written, includeSize);
                }
            }
        }
        catch (IOException impossible) {
            ErrorService.error(impossible);
            return false;
        }
    }

    private byte calculateQueueStatus() {
        int queueSize = this.uploadManager.get().getNumQueuedUploads();
        if (queueSize >= UploadSettings.UPLOAD_QUEUE_SIZE.getValue()) {
            return 127;
        }
        if (queueSize > 0) {
            return (byte)queueSize;
        }
        return (byte)(this.uploadManager.get().uploadsInProgress() - UploadSettings.HARD_MAX_UPLOADS.getValue());
    }

    private byte calculateCode(FileDesc fd) {
        byte code = 0;
        if (!this.networkManager.acceptedIncomingConnection()) {
            code = 4;
        }
        if (fd instanceof IncompleteFileDesc) {
            code = (byte)(code | 2);
            if (this.downloadManager.get().isActivelyDownloading(fd.getSHA1Urn())) {
                code = (byte)(code | 8);
            }
        } else {
            code = (byte)(code | 1);
        }
        return code;
    }

    private byte[] constructGGEPPayload(HeadPongRequestor ping) {
        byte[] bnBytes;
        GGEP ggep = new GGEP();
        URN urn = ping.getUrn();
        FileDesc desc = this.fileManager.get().getSharedFileDescForUrn(urn);
        if (desc == null) {
            ggep.put("C", (byte)0);
            return this.writeGGEP(ggep);
        }
        int size = 1;
        if (this.networkManager.acceptedIncomingConnection() && SSLSettings.isIncomingTLSEnabled()) {
            ggep.put("F", (byte)1);
            size += 4;
        }
        byte code = this.calculateCode(desc);
        ggep.put("C", code);
        size += ggep.getHeaderOverhead("C");
        ggep.put("V", VendorMessage.F_LIME_VENDOR_ID);
        size += ggep.getHeaderOverhead("V");
        ggep.put("Q", this.calculateQueueStatus());
        size += ggep.getHeaderOverhead("Q");
        if ((code & 2) == 2 && ping.requestsRanges()) {
            IntervalSet.ByteIntervals ranges = this.deriveRanges(desc);
            if (ranges.length() == 0) {
                ggep.put("Q", (byte)127);
            } else if (size + ranges.length() + 11 <= PACKET_SIZE) {
                if (ranges.ints.length > 0) {
                    ggep.put("R", ranges.ints);
                    size += ggep.getHeaderOverhead("R");
                }
                if (ranges.longs.length > 0) {
                    ggep.put("R5", ranges.longs);
                    size += ggep.getHeaderOverhead("R5");
                }
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.addPushLocations(ping, urn, out, true, size + 5, false);
        if (out.size() > 0) {
            byte[] pushLocs = out.toByteArray();
            ggep.put("P", pushLocs);
            size += ggep.getHeaderOverhead("P");
        }
        out.reset();
        AtomicReference<BitNumbers> bnRef = new AtomicReference<BitNumbers>();
        this.addLocations(ping, urn, out, bnRef, size + 5, false);
        if (out.size() > 0) {
            byte[] altLocs = out.toByteArray();
            ggep.put("A", altLocs);
            size += ggep.getHeaderOverhead("A");
        }
        assert (size <= PACKET_SIZE) : "size is too big " + size + " vs " + PACKET_SIZE;
        BitNumbers bn = bnRef.get();
        if (bn != null && (bnBytes = bn.toByteArray()).length > 0) {
            ggep.put("T", bnBytes);
            size += ggep.getHeaderOverhead("T");
        }
        byte[] output = this.writeGGEP(ggep);
        assert (output.length == size) : "expected: " + size + ", was: " + output.length;
        return output;
    }

    private byte[] constructBinaryPayload(HeadPongRequestor ping) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CountingOutputStream caos = new CountingOutputStream(baos);
        DataOutputStream daos = new DataOutputStream(caos);
        byte retCode = 0;
        URN urn = ping.getUrn();
        FileDesc desc = this.fileManager.get().getSharedFileDescForUrn(urn);
        boolean didNotSendAltLocs = false;
        boolean didNotSendPushAltLocs = false;
        boolean didNotSendRanges = false;
        try {
            byte features = ping.getFeatures();
            features = (byte)(features & 0xFFFFFFEF);
            daos.write(features);
            if (LOG.isDebugEnabled()) {
                LOG.debug("writing features " + features);
            }
            if (desc == null || desc.getFileSize() > Integer.MAX_VALUE) {
                LOG.debug("we do not have the file");
                daos.write(0);
                return baos.toByteArray();
            }
            retCode = this.calculateCode(desc);
            daos.write(retCode);
            if (LOG.isDebugEnabled()) {
                LOG.debug("our return code is " + retCode);
            }
            daos.write(VendorMessage.F_LIME_VENDOR_ID);
            daos.writeByte(this.calculateQueueStatus());
            if ((retCode & 2) == 2 && ping.requestsRanges()) {
                didNotSendRanges = !this.writeRanges(caos, desc);
            }
            didNotSendPushAltLocs = this.addPushLocations(ping, urn, caos, false, caos.getAmountWritten(), true);
            didNotSendAltLocs = this.addLocations(ping, urn, caos, null, caos.getAmountWritten(), true);
        }
        catch (IOException impossible) {
            ErrorService.error(impossible);
        }
        byte[] ret = baos.toByteArray();
        if (didNotSendRanges) {
            LOG.debug("not sending ranges");
            ret[0] = (byte)(ret[0] & 0xFFFFFFFE);
        }
        if (didNotSendAltLocs) {
            LOG.debug("not sending altlocs");
            ret[0] = (byte)(ret[0] & 0xFFFFFFFD);
        }
        if (didNotSendPushAltLocs) {
            LOG.debug("not sending push altlocs");
            ret[0] = (byte)(ret[0] & 0xFFFFFFFB);
        }
        return ret;
    }

    private byte[] derivePayload(HeadPongRequestor ping) {
        if (!ping.isPongGGEPCapable()) {
            return this.constructBinaryPayload(ping);
        }
        return this.constructGGEPPayload(ping);
    }

    private int versionFor(HeadPongRequestor ping) {
        if (!ping.isPongGGEPCapable()) {
            return 1;
        }
        return 2;
    }

    private final IntervalSet.ByteIntervals deriveRanges(FileDesc desc) {
        return ((IncompleteFileDesc)desc).getRangesAsByte();
    }

    private final boolean writeLocs(OutputStream out, Iterator<DirectAltLoc> altlocs, AtomicReference<BitNumbers> tlsIndexes, int written, boolean includeSize) throws IOException {
        if (!altlocs.hasNext()) {
            return false;
        }
        int toSend = (PACKET_SIZE - (written + (includeSize ? 2 : 0))) / 6;
        if (toSend == 0) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("trying to add up to " + toSend + " locs to pong");
        }
        BitNumbers bn = null;
        if (tlsIndexes != null) {
            bn = new BitNumbers(toSend);
            tlsIndexes.set(bn);
        }
        ByteArrayOutputStream baos = includeSize ? new ByteArrayOutputStream() : (ByteArrayOutputStream)out;
        int sent = 0;
        long now = System.currentTimeMillis();
        while (altlocs.hasNext() && sent < toSend) {
            DirectAltLoc loc = altlocs.next();
            if (loc.canBeSent(0)) {
                loc.send(now, 0);
                baos.write(loc.getHost().getInetAddress().getAddress());
                ByteUtils.short2leb((short)loc.getHost().getPort(), baos);
                IpPort host = loc.getHost();
                if (bn != null && host instanceof Connectable && ((Connectable)host).isTLSCapable()) {
                    bn.set(sent);
                }
                ++sent;
                continue;
            }
            if (loc.canBeSentAny()) continue;
            altlocs.remove();
        }
        LOG.debug("adding altlocs");
        if (includeSize) {
            ByteUtils.short2beb((short)baos.size(), out);
            baos.writeTo(out);
        }
        return true;
    }

    private final boolean writePushLocs(OutputStream out, Iterator<PushAltLoc> pushlocs, boolean includeTLS, int written, boolean includeSize) throws IOException {
        ByteArrayOutputStream baos;
        if (!pushlocs.hasNext()) {
            return false;
        }
        int available = (PACKET_SIZE - (written + (includeSize ? 2 : 0))) / (includeTLS ? 48 : 47);
        if (available == 0) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("trying to add up to " + available + " push locs to pong");
        }
        long now = System.currentTimeMillis();
        ByteArrayOutputStream byteArrayOutputStream = baos = includeSize ? new ByteArrayOutputStream() : (ByteArrayOutputStream)out;
        while (pushlocs.hasNext() && available > 0) {
            PushAltLoc loc = pushlocs.next();
            if (loc.getPushAddress().getProxies().isEmpty()) {
                pushlocs.remove();
                continue;
            }
            if (loc.canBeSent(0)) {
                baos.write(loc.getPushAddress().toBytes(includeTLS));
                --available;
                loc.send(now, 0);
                continue;
            }
            if (loc.canBeSentAny()) continue;
            pushlocs.remove();
        }
        if (baos.size() == 0) {
            LOG.debug("did not send any push locs");
            return false;
        }
        LOG.debug("adding push altlocs");
        if (includeSize) {
            ByteUtils.short2beb((short)baos.size(), out);
            baos.writeTo(out);
        }
        return true;
    }

    private final boolean writeRanges(CountingOutputStream caos, FileDesc desc) throws IOException {
        DataOutputStream daos = new DataOutputStream(caos);
        LOG.debug("adding ranges to pong");
        IntervalSet.ByteIntervals ranges = this.deriveRanges(desc);
        assert (ranges.longs.length == 0) : "long ranges in legacy pong";
        if (caos.getAmountWritten() + 2 + ranges.ints.length <= PACKET_SIZE) {
            LOG.debug("added ranges");
            daos.writeShort((short)ranges.ints.length);
            caos.write(ranges.ints);
            return true;
        }
        LOG.debug("ranges will not fit :(");
        return false;
    }
}

