/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.messages.vendor.InspectionRequest;
import com.limegroup.gnutella.messages.vendor.InspectionResponse;
import com.limegroup.gnutella.messages.vendor.InspectionResponseFactory;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.FECUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import org.limewire.inspection.InspectionException;
import org.limewire.inspection.Inspector;
import org.limewire.io.GGEP;
import org.limewire.io.IOUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.BEncoder;
import org.limewire.util.CommonUtils;

@Singleton
public class InspectionResponseFactoryImpl
implements InspectionResponseFactory {
    private static final String INSPECTION_FILE = "inspection.props";
    private static final int OLD_VERSION = 1;
    private static final int GGEP_VERSION = 2;
    private static final String DATA_KEY = "D";
    private static final String CHUNK_ID_KEY = "I";
    private static final String TOTAL_CHUNKS_KEY = "T";
    private static final String LENGTH_KEY = "L";
    private static final int PACKET_SIZE = 1300;
    private static final float REDUNDANCY = 1.2f;
    private final Inspector inspector;
    private final FECUtils fecUtils;

    @Inject
    public InspectionResponseFactoryImpl(Inspector inspector, FECUtils fecUtils) {
        this.inspector = inspector;
        this.inspector.load(new File(CommonUtils.getCurrentDirectory(), INSPECTION_FILE));
        this.fecUtils = fecUtils;
    }

    public InspectionResponse[] createResponses(InspectionRequest request) {
        byte[] payload = this.derivePayload(request);
        if (payload.length < 1300 || !request.supportsEncoding()) {
            return new InspectionResponse[]{new InspectionResponse(1, request.getGUID(), payload)};
        }
        List<byte[]> chunks = this.fecUtils.encode(payload, 1300, 1.2f);
        ArrayList<InspectionResponse> ret = new ArrayList<InspectionResponse>(chunks.size());
        for (int i = 0; i < chunks.size(); ++i) {
            GGEP g = new GGEP();
            g.put(DATA_KEY, chunks.get(i));
            g.put(CHUNK_ID_KEY, i);
            g.put(TOTAL_CHUNKS_KEY, chunks.size());
            g.put(LENGTH_KEY, payload.length);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                g.write(baos);
            }
            catch (IOException impossible) {
                continue;
            }
            ret.add(new InspectionResponse(2, request.getGUID(), baos.toByteArray()));
        }
        InspectionResponse[] rett = new InspectionResponse[ret.size()];
        return ret.toArray(rett);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] derivePayload(InspectionRequest request) {
        String[] requested = request.getRequestedFields();
        HashMap<Integer, Object> responses = new HashMap<Integer, Object>(requested.length);
        if (request.requestsTimeStamp()) {
            responses.put(-1, System.currentTimeMillis());
        }
        for (int i = 0; i < requested.length; ++i) {
            try {
                responses.put(i, this.inspector.inspect(requested[i]));
                continue;
            }
            catch (InspectionException skip) {
                // empty catch block
            }
        }
        if (responses.isEmpty()) {
            return DataUtils.EMPTY_BYTE_ARRAY;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream(baos);
        try {
            try {
                BEncoder.getEncoder(dos, false, true, "UTF-8").encodeDict(responses);
            }
            catch (Throwable bencoding) {
                String msg = bencoding.toString();
                String ret = "d5:error" + msg.length() + ":" + msg + "e";
                dos.write(ret.getBytes());
            }
            dos.flush();
        }
        catch (IOException impossible) {
            ErrorService.error(impossible);
        }
        finally {
            IOUtils.close(dos);
        }
        return baos.toByteArray();
    }
}

