/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.security.SecurityToken;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;

public final class LimeACKVendorMessage
extends AbstractVendorMessage {
    public static final int VERSION = 3;
    public static final int OLD_VERSION = 2;
    private static final int PAYLOAD_MIN_LENGTH_V3 = LimeACKVendorMessage.derivePayloadV3(255, new byte[1]).length;

    LimeACKVendorMessage(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, F_LIME_VENDOR_ID, 11, version, payload, network);
        if (this.getVersion() == 1) {
            throw new BadPacketException("UNSUPPORTED OLD VERSION");
        }
        if (this.getPayload().length < 1) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + this.getPayload().length);
        }
        if (this.getVersion() == 2 && this.getPayload().length != 1) {
            throw new BadPacketException("VERSION 2 UNSUPPORTED PAYLOAD LEN: " + this.getPayload().length);
        }
        if (this.getVersion() == 3 && this.getPayload().length < PAYLOAD_MIN_LENGTH_V3) {
            throw new BadPacketException("VERSION 3 should have a GGEP");
        }
    }

    public LimeACKVendorMessage(GUID replyGUID, int numResults) {
        super(F_LIME_VENDOR_ID, 11, 2, LimeACKVendorMessage.derivePayload(numResults));
        this.setGUID(replyGUID);
    }

    public LimeACKVendorMessage(GUID replyGUID, int numResults, SecurityToken securityToken) {
        super(F_LIME_VENDOR_ID, 11, 3, LimeACKVendorMessage.derivePayloadV3(numResults, securityToken.getBytes()));
        this.setGUID(replyGUID);
    }

    public int getNumResults() {
        return ByteUtils.ubyte2int(this.getPayload()[0]);
    }

    public SecurityToken getSecurityToken() {
        if (this.getVersion() > 2) {
            try {
                GGEP ggep = new GGEP(this.getPayload(), 1);
                if (ggep.hasKey("SO")) {
                    return new UnknownSecurityToken(ggep.getBytes("SO"));
                }
            }
            catch (BadGGEPPropertyException corrupt) {
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
                // empty catch block
            }
        }
        return null;
    }

    private static byte[] derivePayload(int numResults) {
        if (numResults < 0 || numResults > 255) {
            throw new IllegalArgumentException("Number of results too big: " + numResults);
        }
        byte[] payload = new byte[1];
        byte[] bytes = new byte[2];
        ByteUtils.short2leb((short)numResults, bytes, 0);
        payload[0] = bytes[0];
        return payload;
    }

    private static byte[] derivePayloadV3(int numResults, byte[] securityTokenBytes) {
        if (numResults <= 0 || numResults > 255) {
            throw new IllegalArgumentException("Number of results too big: " + numResults);
        }
        byte[] bytes = new byte[2];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteUtils.short2leb((short)numResults, bytes, 0);
        out.write(bytes[0]);
        GGEP ggep = new GGEP();
        ggep.put("SO", securityTokenBytes);
        try {
            ggep.write(out);
        }
        catch (IOException iox) {
            ErrorService.error(iox);
        }
        return out.toByteArray();
    }

    public boolean equals(Object other) {
        if (other instanceof LimeACKVendorMessage) {
            LimeACKVendorMessage o = (LimeACKVendorMessage)other;
            GUID myGuid = new GUID(this.getGUID());
            GUID otherGuid = new GUID(o.getGUID());
            int otherResults = o.getNumResults();
            return myGuid.equals(otherGuid) && this.getNumResults() == otherResults && this.areEqualTokens(this.getSecurityToken(), o.getSecurityToken()) && super.equals(other);
        }
        return false;
    }

    private final boolean areEqualTokens(SecurityToken t1, SecurityToken t2) {
        return t1 == t2 || t1 != null && t2 != null && Arrays.equals(t1.getBytes(), t2.getBytes());
    }

    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append(", num results: ").append(this.getNumResults());
        builder.append(", security token: ").append(this.getSecurityToken());
        return builder.toString();
    }

    private class UnknownSecurityToken
    implements SecurityToken {
        private final byte[] data;

        public UnknownSecurityToken(byte[] data) {
            this.data = data;
        }

        public byte[] getBytes() {
            return this.data;
        }

        public boolean isFor(SecurityToken.TokenData data) {
            return false;
        }

        public void write(OutputStream out) throws IOException {
            out.write(this.data);
        }
    }
}

