/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;

public final class TCPConnectBackVendorMessage
extends AbstractVendorMessage {
    public static final int VERSION = 1;
    private final int _port;

    TCPConnectBackVendorMessage(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        super(guid, ttl, hops, F_BEAR_VENDOR_ID, 7, version, payload, network);
        if (this.getVersion() > 1) {
            throw new BadPacketException("UNSUPPORTED VERSION");
        }
        if (this.getPayload().length != 2) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + payload.length);
        }
        this._port = ByteUtils.ushort2int(ByteUtils.leb2short(this.getPayload(), 0));
        if (!NetworkUtils.isValidPort(this._port)) {
            throw new BadPacketException("invalid port");
        }
    }

    public TCPConnectBackVendorMessage(int port) {
        super(F_BEAR_VENDOR_ID, 7, 1, TCPConnectBackVendorMessage.derivePayload(port));
        this._port = port;
    }

    public int getConnectBackPort() {
        return this._port;
    }

    private static byte[] derivePayload(int port) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteUtils.short2leb((short)port, baos);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
            return null;
        }
    }

    protected void writePayload(OutputStream out) throws IOException {
        super.writePayload(out);
    }
}

