/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.Constants;
import com.limegroup.gnutella.connection.RoutedConnection;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPong;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPongFactory;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class UDPCrawlerPongFactoryImpl
implements UDPCrawlerPongFactory {
    private final Provider<DHTManager> dhtManager;
    private final Provider<ConnectionManager> connectionManager;

    @Inject
    public UDPCrawlerPongFactoryImpl(Provider<DHTManager> dhtManager, Provider<ConnectionManager> connectionManager) {
        this.dhtManager = dhtManager;
        this.connectionManager = connectionManager;
    }

    @Override
    public UDPCrawlerPong createUDPCrawlerPong(UDPCrawlerPing request) {
        return new UDPCrawlerPong(request, this.derivePayload(request));
    }

    private byte[] derivePayload(UDPCrawlerPing request) {
        byte format = (byte)(request.getFormat() & 0x7F);
        List endpointsUP = new LinkedList<RoutedConnection>();
        List<RoutedConnection> endpointsLeaf = new LinkedList<RoutedConnection>();
        boolean newOnly = request.hasNewOnly();
        for (RoutedConnection c : this.connectionManager.get().getInitializedConnections()) {
            if (newOnly) {
                if (c.getConnectionCapabilities().remoteHostSupportsUDPCrawling() < 1) continue;
                endpointsUP.add(c);
                continue;
            }
            if (!c.isGoodUltrapeer()) continue;
            endpointsUP.add(c);
        }
        for (RoutedConnection c : this.connectionManager.get().getInitializedClientConnections()) {
            endpointsLeaf.add(c);
        }
        if (!request.hasLocaleInfo()) {
            if (request.getNumberUP() != -1 && request.getNumberUP() < endpointsUP.size()) {
                int index = (int)Math.floor(Math.random() * (double)(endpointsUP.size() - request.getNumberUP()));
                endpointsUP = endpointsUP.subList(index, index + request.getNumberUP());
            }
            if (request.getNumberLeaves() != -1 && request.getNumberLeaves() < endpointsLeaf.size()) {
                int index = (int)Math.floor(Math.random() * (double)(endpointsLeaf.size() - request.getNumberLeaves()));
                endpointsLeaf = endpointsLeaf.subList(index, index + request.getNumberLeaves());
            }
        } else {
            String myLocale = ApplicationSettings.LANGUAGE.getValue();
            List<RoutedConnection> prefedcons = this.connectionManager.get().getInitializedConnectionsMatchLocale(myLocale);
            for (RoutedConnection c : prefedcons) {
                endpointsUP.remove(c);
                endpointsUP.add(0, c);
            }
            prefedcons = this.connectionManager.get().getInitializedClientConnectionsMatchLocale(myLocale);
            for (RoutedConnection c : prefedcons) {
                endpointsLeaf.remove(c);
                endpointsLeaf.add(0, c);
            }
            if (request.getNumberUP() != -1 && request.getNumberUP() < endpointsUP.size()) {
                endpointsUP = endpointsUP.subList(0, request.getNumberUP());
            }
            if (request.getNumberLeaves() != -1 && request.getNumberLeaves() < endpointsLeaf.size()) {
                endpointsLeaf = endpointsLeaf.subList(0, request.getNumberLeaves());
            }
        }
        int bytesPerResult = 6;
        if (request.hasConnectionTime()) {
            bytesPerResult += 2;
        }
        if (request.hasLocaleInfo()) {
            bytesPerResult += 2;
        }
        if (request.hasReplies()) {
            bytesPerResult += 4;
        }
        int index = 3;
        if (request.hasNodeUptime()) {
            index += 4;
        }
        if (request.hasDHTStatus()) {
            ++index;
        }
        byte[] result = new byte[(endpointsUP.size() + endpointsLeaf.size()) * bytesPerResult + index];
        result[0] = (byte)endpointsUP.size();
        result[1] = (byte)endpointsLeaf.size();
        result[2] = format;
        if (request.hasNodeUptime()) {
            long currentAverage = this.connectionManager.get().getCurrentAverageUptime() / 1000L;
            if (currentAverage > Integer.MAX_VALUE) {
                currentAverage = Integer.MAX_VALUE;
            }
            ByteUtils.int2leb((int)currentAverage, result, 3);
        }
        if (request.hasDHTStatus()) {
            byte dhtStatus = 0;
            DHTManager manager = this.dhtManager.get();
            if (manager.isRunning()) {
                switch (manager.getDHTMode()) {
                    case ACTIVE: {
                        dhtStatus = (byte)(dhtStatus | 2);
                        break;
                    }
                    case PASSIVE: {
                        dhtStatus = (byte)(dhtStatus | 4);
                        break;
                    }
                    case PASSIVE_LEAF: {
                        dhtStatus = (byte)(dhtStatus | 8);
                    }
                }
                if (!manager.isMemberOfDHT()) {
                    dhtStatus = (byte)(dhtStatus | 1);
                }
            }
            result[index - 1] = dhtStatus;
        }
        endpointsUP.addAll(endpointsLeaf);
        long now = System.currentTimeMillis();
        for (RoutedConnection c : endpointsUP) {
            System.arraycopy(NetworkUtils.getBytes(c.getInetAddress(), c.getPort(), ByteOrder.LITTLE_ENDIAN), 0, result, index, 6);
            index += 6;
            if (request.hasConnectionTime()) {
                long uptime = now - c.getConnectionTime();
                short packed = (short)(uptime / Constants.MINUTE);
                ByteUtils.short2leb(packed, result, index);
                index += 2;
            }
            if (request.hasLocaleInfo()) {
                System.arraycopy(c.getLocalePref().getBytes(), 0, result, index, 2);
                index += 2;
            }
            if (!request.hasReplies()) continue;
            ByteUtils.int2leb(ByteUtils.long2int(c.getConnectionMessageStatistics().getNumQueryReplies()), result, index);
            index += 4;
        }
        if (request.hasUserAgent()) {
            StringBuilder agents = new StringBuilder();
            for (RoutedConnection c : endpointsUP) {
                String agent = c.getConnectionCapabilities().getUserAgent();
                agent = StringUtils.replace(agent, ";", "\\;");
                agents.append(agent).append(";");
            }
            agents.append(LimeWireUtils.getHttpServer());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                GZIPOutputStream zout = new GZIPOutputStream(baos);
                byte[] length = new byte[2];
                ByteUtils.short2leb((short)agents.length(), length, 0);
                zout.write(length);
                zout.write(agents.toString().getBytes());
                zout.flush();
                zout.close();
            }
            catch (IOException huh) {
                ErrorService.error(huh);
            }
            byte[] agentsB = baos.toByteArray();
            byte[] resTemp = result;
            result = new byte[result.length + agentsB.length + 2];
            System.arraycopy(resTemp, 0, result, 0, resTemp.length);
            ByteUtils.short2leb((short)agentsB.length, result, resTemp.length);
            System.arraycopy(agentsB, 0, result, resTemp.length + 2, agentsB.length);
        }
        return result;
    }
}

