/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import com.limegroup.gnutella.messages.vendor.UpdateRequest;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.limewire.io.BadGGEPBlockException;
import org.limewire.io.BadGGEPPropertyException;
import org.limewire.io.GGEP;
import org.limewire.service.ErrorService;

public final class UpdateResponse
extends AbstractVendorMessage
implements VendorMessage.ControlMessage {
    private static final int NON_GGEP_VERSION = 1;
    private static final int OLD_KEY_VERSION = 2;
    private static final int NEW_KEY_VERSION = 3;
    public static final int VERSION = 3;
    private byte[] update;

    UpdateResponse(byte[] guid, byte ttl, byte hops, int version, byte[] payload, Message.Network network) throws BadPacketException {
        block7: {
            super(guid, ttl, hops, F_LIME_VENDOR_ID, 27, version, payload, network);
            if (version == 1) {
                this.update = payload;
            } else {
                try {
                    GGEP ggep = new GGEP(payload, 0, null);
                    if (ggep.hasKey("U")) {
                        this.update = ggep.getBytes("U");
                        break block7;
                    }
                    if (ggep.hasKey("C")) {
                        this.update = ggep.getBytes("C");
                        break block7;
                    }
                    throw new BadPacketException("no update in GGEP?");
                }
                catch (BadGGEPPropertyException bad) {
                    throw new BadPacketException("bad ggep property");
                }
                catch (BadGGEPBlockException notSoBad) {
                    this.update = payload;
                }
            }
        }
    }

    private UpdateResponse(byte[] body, int version) {
        super(F_LIME_VENDOR_ID, 27, version, body);
    }

    public static UpdateResponse createUpdateResponse(byte[] update, UpdateRequest request) {
        if (!request.isOldRequest()) {
            byte[] ggep = UpdateResponse.createGGEP(request, update);
            return new UpdateResponse(ggep, 3);
        }
        if (!request.hasGGEP()) {
            return new UpdateResponse(update, 1);
        }
        byte[] ggep = UpdateResponse.createGGEP(request, update);
        return new UpdateResponse(ggep, 2);
    }

    public boolean isNewVersion() {
        return this.getVersion() >= 3;
    }

    private static byte[] createGGEP(UpdateRequest request, byte[] update) {
        GGEP ggep = new GGEP();
        if (request.requestsCompressed()) {
            ggep.putCompressed("C", update);
        } else {
            ggep.put("U", update);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ggep.write(baos);
        }
        catch (IOException bad) {
            ErrorService.error(bad);
        }
        return baos.toByteArray();
    }

    public byte[] getUpdate() {
        return this.update;
    }
}

