/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessageFactory;
import com.limegroup.gnutella.messages.vendor.VendorMessageParserBinder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Comparators;
import org.limewire.collection.IntHashMap;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class VendorMessageFactoryImpl
implements VendorMessageFactory {
    private static final Log LOG = LogFactory.getLog(VendorMessageFactoryImpl.class);
    private static final Comparator<byte[]> COMPARATOR = new Comparators.ByteArrayComparator();
    private volatile Map<byte[], IntHashMap<VendorMessageFactory.VendorMessageParser>> VENDORS = new TreeMap<byte[], IntHashMap<VendorMessageFactory.VendorMessageParser>>(COMPARATOR);
    private static final BadPacketException UNRECOGNIZED_EXCEPTION = new BadPacketException("Unrecognized Vendor Message");

    public VendorMessageFactoryImpl() {
    }

    @Inject
    public VendorMessageFactoryImpl(VendorMessageParserBinder vendorMessageParserBinder) {
        vendorMessageParserBinder.bind(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParser(int selector, byte[] vendorId, VendorMessageFactory.VendorMessageParser parser) {
        if (selector < 0 || selector > 65535) {
            throw new IllegalArgumentException("Selector is out of range: " + selector);
        }
        if (vendorId == null) {
            throw new NullPointerException("Vendor ID is null");
        }
        if (vendorId.length != 4) {
            throw new IllegalArgumentException("Vendor ID must be 4 bytes long");
        }
        if (parser == null) {
            throw new NullPointerException("VendorMessageParser is null");
        }
        VendorMessageFactory.VendorMessageParser o = null;
        Map<byte[], IntHashMap<VendorMessageFactory.VendorMessageParser>> map = this.VENDORS;
        synchronized (map) {
            Map<byte[], IntHashMap<VendorMessageFactory.VendorMessageParser>> vendors = this.copyVendors();
            IntHashMap<VendorMessageFactory.VendorMessageParser> selectors = vendors.get(vendorId);
            if (selectors == null) {
                selectors = new IntHashMap();
                vendors.put(vendorId, selectors);
            }
            o = selectors.put(selector, parser);
            this.VENDORS = vendors;
        }
        if (o != null && LOG.isErrorEnabled()) {
            LOG.error("There was already a VendorMessageParser of type " + o.getClass() + " registered for selector " + selector);
        }
    }

    private Map<byte[], IntHashMap<VendorMessageFactory.VendorMessageParser>> copyVendors() {
        TreeMap<byte[], IntHashMap<VendorMessageFactory.VendorMessageParser>> copy = new TreeMap<byte[], IntHashMap<VendorMessageFactory.VendorMessageParser>>(COMPARATOR);
        for (Map.Entry<byte[], IntHashMap<VendorMessageFactory.VendorMessageParser>> entry : this.VENDORS.entrySet()) {
            copy.put(entry.getKey(), new IntHashMap<VendorMessageFactory.VendorMessageParser>(entry.getValue()));
        }
        return copy;
    }

    @Override
    public VendorMessageFactory.VendorMessageParser getParser(int selector, byte[] vendorId) {
        IntHashMap<VendorMessageFactory.VendorMessageParser> selectors = this.VENDORS.get(vendorId);
        if (selectors == null) {
            return null;
        }
        return selectors.get(selector);
    }

    @Override
    public VendorMessage deriveVendorMessage(byte[] guid, byte ttl, byte hops, byte[] fromNetwork, Message.Network network) throws BadPacketException {
        if (fromNetwork.length < 8) {
            throw new BadPacketException("Not enough bytes for a VM!!");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(fromNetwork);
        byte[] vendorID = null;
        byte[] restOf = null;
        int selector = -1;
        int version = -1;
        try {
            vendorID = new byte[4];
            bais.read(vendorID, 0, vendorID.length);
            selector = ByteUtils.ushort2int(ByteUtils.leb2short(bais));
            version = ByteUtils.ushort2int(ByteUtils.leb2short(bais));
            restOf = new byte[bais.available()];
            bais.read(restOf, 0, restOf.length);
        }
        catch (IOException ioe) {
            ErrorService.error(ioe);
        }
        VendorMessageFactory.VendorMessageParser parser = this.getParser(selector, vendorID);
        if (parser == null) {
            throw UNRECOGNIZED_EXCEPTION;
        }
        return parser.parse(guid, ttl, hops, version, restOf, network);
    }
}

