/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.audio.reader;

import com.limegroup.gnutella.metadata.audio.reader.AudioDataReader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.ID3v1Tag;

public class MP3MetaData
extends AudioDataReader {
    public MP3MetaData(File f) throws IOException, IllegalArgumentException {
        super(f);
    }

    protected void readTag(AudioFile audioFile, Tag tag) {
        MP3File mp3File = (MP3File)audioFile;
        mp3File.getID3v1Tag();
        AbstractID3v2Tag v2Tag = mp3File.getID3v2Tag();
        ID3v1Tag v1Tag = mp3File.getID3v1Tag();
        if (v2Tag != null) {
            this.readV2Tag(v2Tag);
        }
        if (v1Tag != null) {
            this.readV1Tag(v1Tag);
        }
    }

    private void readV1Tag(ID3v1Tag tag) {
        if (this.audioData.getTitle() == null || this.audioData.getTitle().length() == 0) {
            this.audioData.setTitle(tag.getFirstTitle());
        }
        if (this.audioData.getArtist() == null || this.audioData.getArtist().length() == 0) {
            this.audioData.setArtist(tag.getFirstArtist());
        }
        if (this.audioData.getAlbum() == null || this.audioData.getAlbum().length() == 0) {
            this.audioData.setAlbum(tag.getFirstAlbum());
        }
        if (this.audioData.getYear() == null || this.audioData.getYear().length() == 0) {
            this.audioData.setYear(tag.getFirstYear());
        }
        if (this.audioData.getComment() == null || this.audioData.getComment().length() == 0) {
            this.audioData.setComment(tag.getFirstComment());
        }
        if (this.audioData.getGenre() == null || this.audioData.getGenre().length() == 0) {
            this.audioData.setGenre(tag.getFirstGenre());
        }
        if (this.audioData.getTrack() == null || this.audioData.getTrack().length() == 0) {
            try {
                this.audioData.setTrack(tag.getFirstTrack());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private void readV2Tag(AbstractID3v2Tag tag) {
        this.audioData.setTitle(tag.getFirstTitle());
        this.audioData.setArtist(tag.getFirstArtist());
        this.audioData.setAlbum(tag.getFirstAlbum());
        this.audioData.setYear(tag.getFirstYear());
        this.audioData.setComment(tag.getFirstComment());
        this.audioData.setGenre(this.parseGenre(tag.getFirstGenre()));
        this.audioData.setTrack(tag.getFirstTrack());
        this.audioData.setLicense(tag.getFirst("TCOP"));
        Iterator iter = tag.iterator();
        while (iter.hasNext()) {
            AbstractID3v2Frame o;
            if (this.audioData.getLicenseType() != null && this.audioData.getLicenseType().equals("NOT CLEARED")) {
                return;
            }
            Object nextFrame = iter.next();
            if (!(nextFrame instanceof AbstractID3v2Frame) || (o = (AbstractID3v2Frame)nextFrame).getId().equals("TIT2") || o.getId().equals("TALB") || o.getId().equals("TOAL") || o.getId().equals("TOPE") || o.getId().equals("TPE1") || o.getId().equals("TPE2") || o.getId().equals("TPE3") || o.getId().equals("TPE4")) continue;
            if (o.getBody().getObject("Text") != null) {
                this.checkLWS(o.getBody().getObject("Text").toString());
                continue;
            }
            this.isRawCheck(o.getRawContent());
        }
    }

    private void isRawCheck(byte[] contentBytes) {
        try {
            String content = new String(contentBytes, "UTF-8");
            this.checkLWS(content);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void checkLWS(String content) {
        if (!(this.audioData.getLicenseType() != null && this.audioData.getLicenseType().equals("NOT CLEARED") || content.indexOf("NOT CLEARED") == -1)) {
            this.audioData.setLicenseType("NOT CLEARED");
        }
    }

    private String parseGenre(String genre) {
        if (genre == null || genre.length() <= 0) {
            return genre;
        }
        String cleanGenre = genre;
        if (genre.charAt(0) == '(') {
            int startIndex = 0;
            for (int i = 0; i < genre.length(); ++i) {
                if (genre.charAt(i) != ')') continue;
                startIndex = i + 1;
            }
            cleanGenre = genre.substring(startIndex);
        }
        return cleanGenre;
    }
}

