/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.audio.writer;

import com.limegroup.gnutella.metadata.audio.writer.AudioDataEditor;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagFieldKey;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3v11Tag;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.jaudiotagger.tag.id3.ID3v23Tag;

public class MP3DataEditor
extends AudioDataEditor {
    protected Tag updateTag(Tag tag, AudioFile audioFile) throws FieldDataInvalidException {
        if (tag instanceof AbstractID3v2Tag) {
            tag.set(tag.createTagField(TagFieldKey.COPYRIGHT, this.audioData.getLicense()));
        }
        return super.updateTag(tag, audioFile);
    }

    protected Tag createTag(AudioFile audioFile) {
        if (audioFile.getTag() == null) {
            return new ID3v23Tag();
        }
        MP3File mp3File = (MP3File)audioFile;
        if (mp3File.hasID3v2Tag()) {
            return mp3File.getID3v2Tag();
        }
        if (mp3File.hasID3v1Tag()) {
            ID3v1Tag tag = mp3File.getID3v1Tag();
            if (this.audioData.getLicense() != null && !this.audioData.getLicense().equals("")) {
                return new ID3v23Tag((AbstractTag)tag);
            }
            if (tag instanceof ID3v11Tag) {
                return tag;
            }
            return new ID3v11Tag((AbstractTag)tag);
        }
        return new ID3v23Tag();
    }

    protected boolean isValidFileType(String fileName) {
        return LimeXMLUtils.isMP3File(fileName);
    }
}

