/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.video.reader;

import com.limegroup.gnutella.metadata.video.reader.VideoDataReader;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.limewire.io.IOUtils;

public class MOVMetaData
extends VideoDataReader {
    private long length = -1L;

    public MOVMetaData(File f) throws IOException {
        super(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseFile(File f) throws IOException {
        RandomAccessFile in = null;
        try {
            this.length = f.length();
            in = new RandomAccessFile(f, "r");
            this.parseAtoms(in);
        }
        catch (Throwable throwable) {
            IOUtils.close(in);
            throw throwable;
        }
        IOUtils.close(in);
    }

    private void parseAtoms(DataInput in) throws IOException {
        Atom atom = null;
        while ((atom = this.nextAtom(in)) != null) {
            if (atom.isType("moov")) {
                this.moov(atom, in);
                break;
            }
            MOVMetaData.skip(atom.remaining, in);
        }
    }

    private void moov(Atom moov, DataInput in) throws IOException {
        Atom atom = null;
        for (long length = 0L; length < moov.remaining && (atom = this.nextAtom(in)) != null; length += atom.size) {
            if (atom.isType("mvhd")) {
                this.mvhd(atom, in);
                continue;
            }
            if (atom.isType("cmov")) {
                this.cmov(atom, in);
                continue;
            }
            if (atom.isType("trak")) {
                this.trak(atom, in);
                continue;
            }
            MOVMetaData.skip(atom.remaining, in);
        }
    }

    private void mvhd(Atom mvhd, DataInput in) throws IOException {
        assert (mvhd.remaining == 100L);
        in.skipBytes(12);
        int timeScale = in.readInt();
        int timeUnits = in.readInt();
        int length = timeUnits / timeScale;
        if (length > this.videoData.getLength()) {
            this.videoData.setLength(length);
        }
        long toSkip = mvhd.remaining - 12L - 4L - 4L;
        assert (toSkip == 80L);
        MOVMetaData.skip(toSkip, in);
    }

    private void cmov(Atom cmov, DataInput in) throws IOException {
        Atom atom = null;
        for (long length = 0L; length < cmov.remaining && (atom = this.nextAtom(in)) != null; length += atom.size) {
            if (atom.isType("cmvd")) {
                this.cmvd(atom, in);
                continue;
            }
            MOVMetaData.skip(atom.remaining, in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmvd(Atom cmvd, DataInput in) throws IOException {
        int decompressedSize = in.readInt();
        if (cmvd == null || cmvd.remaining - 4L > Integer.MAX_VALUE || cmvd.remaining < 4L) {
            throw new IOException("File smaller than expected");
        }
        byte[] compressed = new byte[(int)(cmvd.remaining - 4L)];
        in.readFully(compressed);
        Inflater decompresser = new Inflater();
        try {
            decompresser.setInput(compressed);
            if (decompressedSize > Integer.MAX_VALUE || decompressedSize < 0) {
                throw new IOException("Illegal atom size");
            }
            byte[] decompressed = new byte[decompressedSize];
            int num = -1;
            try {
                num = decompresser.inflate(decompressed);
            }
            catch (DataFormatException e) {
                throw new IOException(e.getMessage());
            }
            finally {
                decompresser.end();
            }
            if (num < decompressedSize) {
                throw new EOFException("Decompressed size is less than expected: " + num + " < " + decompressedSize);
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(decompressed);
            DataInputStream dis = new DataInputStream(bais);
            try {
                this.parseAtoms(dis);
            }
            finally {
                dis.close();
            }
        }
        finally {
            IOUtils.close(decompresser);
        }
    }

    private void trak(Atom trak, DataInput in) throws IOException {
        Atom atom = null;
        for (long length = 0L; length < trak.remaining && (atom = this.nextAtom(in)) != null; length += atom.size) {
            if (atom.isType("tkhd")) {
                this.tkhd(atom, in);
                continue;
            }
            MOVMetaData.skip(atom.remaining, in);
        }
    }

    private void tkhd(Atom tkhd, DataInput in) throws IOException {
        assert (tkhd.remaining == 84L);
        MOVMetaData.skip(76L, in);
        int width = MOVMetaData.toTwoCompliant(in.readInt());
        int height = MOVMetaData.toTwoCompliant(in.readInt());
        if (width > this.videoData.getWidth()) {
            this.videoData.setWidth(width);
        }
        if (height > this.videoData.getHeight()) {
            this.videoData.setHeight(height);
        }
    }

    private static int toTwoCompliant(int value) {
        return value / 65536;
    }

    private static long skip(long toSkip, DataInput in) throws IOException {
        long skipped;
        int s;
        for (skipped = 0L; skipped < toSkip; skipped += (long)s) {
            s = (int)Math.min(toSkip - skipped, Integer.MAX_VALUE);
            int num = in.skipBytes(s);
            if (num == s) continue;
            throw new EOFException("Could not skip " + s + " bytes: " + num);
        }
        return skipped;
    }

    private Atom nextAtom(DataInput in) throws IOException {
        long size = (long)in.readInt() & 0xFFFFFFFFL;
        if (size == 0L) {
            return null;
        }
        boolean extened = false;
        String atom = MOVMetaData.toAtomName(in.readInt());
        if (size == 1L) {
            size = in.readLong();
            extened = true;
        }
        if (size > this.length) {
            throw new IOException("Size is too big: " + size + " > " + this.length);
        }
        return new Atom(atom, size, extened);
    }

    private static String toAtomName(int atomType) throws UnsupportedEncodingException {
        byte[] atomName = new byte[]{(byte)(atomType >> 24 & 0xFF), (byte)(atomType >> 16 & 0xFF), (byte)(atomType >> 8 & 0xFF), (byte)(atomType & 0xFF)};
        return new String(atomName, "8859_1");
    }

    private static class Atom {
        private final String name;
        private final long size;
        private final long remaining;

        private Atom(String name, long size, boolean extended) {
            this.name = name;
            this.size = size;
            this.remaining = extended ? size - 16L : size - 8L;
        }

        public boolean isType(String name) {
            return this.name.equals(name);
        }

        public String toString() {
            return this.name + "/" + this.size + "/" + Long.toHexString(this.size);
        }
    }
}

