/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.routing.DynamicQRTStorage;
import com.limegroup.gnutella.routing.HashFunction;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.QRTTableStorage;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.util.Utilities;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.limewire.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryRouteTable {
    public static final byte DEFAULT_INFINITY = 7;
    public static final byte KEYWORD_NO_CHANGE = 0;
    public static final int MAX_PATCH_SIZE = 4096;
    private static final AtomicInteger DEFAULT_SIZE = new AtomicInteger(-1);
    private byte infinity;
    private byte keywordPresent;
    private byte keywordAbsent;
    private volatile QRTTableStorage storage;
    private int bitTableLength;
    private int sequenceNumber;
    private int sequenceSize;
    private int nextPatch;
    private volatile Inflater uncompressor;

    public QueryRouteTable() {
        DEFAULT_SIZE.compareAndSet(-1, (int)ConnectionSettings.QRT_SIZE_IN_KIBI_ENTRIES.getValue());
        long byteCount = 1024 * DEFAULT_SIZE.get();
        if (byteCount > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Default QRT size cannot be expressed as an int.");
        }
        this.initialize((int)byteCount, (byte)7);
    }

    public QueryRouteTable(int size) {
        this(size, 7);
    }

    public QueryRouteTable(int size, byte infinity) {
        this.initialize(size, infinity);
    }

    private void initialize(int size, byte infinity) {
        this.bitTableLength = size;
        this.storage = new DynamicQRTStorage(this.bitTableLength);
        this.sequenceNumber = -1;
        this.sequenceSize = -1;
        this.nextPatch = 0;
        this.keywordPresent = (byte)(1 - infinity);
        this.keywordAbsent = (byte)(infinity - 1);
        this.infinity = infinity;
    }

    public int getSize() {
        return this.bitTableLength;
    }

    public double getPercentFull() {
        return this.storage.getPercentFull();
    }

    public int getEmptyUnits() {
        return this.storage.getUnusedUnits();
    }

    public int getUnitsInUse() {
        return this.storage.getUnitsInUse();
    }

    public int getUnitsWithLoad(int load) {
        return this.storage.numUnitsWithLoad(load);
    }

    public boolean contains(QueryRequest qr) {
        int j;
        byte bits = Utilities.log2(this.bitTableLength);
        String query = qr.getQuery();
        LimeXMLDocument richQuery = qr.getRichQuery();
        if (query.length() == 0 && richQuery == null && !qr.hasQueryUrns()) {
            return false;
        }
        if (qr.hasQueryUrns()) {
            Set<URN> urns = qr.getQueryUrns();
            for (URN qurn : urns) {
                int hash = HashFunction.hash(qurn.toString(), bits);
                if (!this.contains(hash)) continue;
                return true;
            }
            return false;
        }
        int i = 0;
        while ((j = HashFunction.keywordStart(query, i)) >= 0) {
            int k = HashFunction.keywordEnd(query, j);
            int hash = HashFunction.hash(query, j, k, bits);
            if (!this.contains(hash)) {
                return false;
            }
            i = k + 1;
        }
        if (richQuery == null) {
            return true;
        }
        String docSchemaURI = richQuery.getSchemaURI();
        int hash = HashFunction.hash(docSchemaURI, bits);
        if (!this.contains(hash)) {
            return false;
        }
        int wordCount = 0;
        int matchCount = 0;
        for (String words : richQuery.getKeyWords()) {
            int j2;
            int i2 = 0;
            while ((j2 = HashFunction.keywordStart(words, i2)) >= 0) {
                int k = HashFunction.keywordEnd(words, j2);
                int wordHash = HashFunction.hash(words, j2, k, bits);
                if (this.contains(wordHash)) {
                    ++matchCount;
                }
                ++wordCount;
                i2 = k + 1;
            }
        }
        for (String str : richQuery.getKeyWordsIndivisible()) {
            hash = HashFunction.hash(str, bits);
            if (this.contains(hash)) {
                ++matchCount;
            }
            ++wordCount;
        }
        if (wordCount < 3) {
            return wordCount == matchCount;
        }
        return (double)((float)matchCount / (float)wordCount) > 0.67;
    }

    private final boolean contains(int hash) {
        return this.storage.get(hash);
    }

    public void add(String filePath) {
        this.addBTInternal(filePath);
    }

    private void addBTInternal(String filePath) {
        String[] words = HashFunction.keywords(filePath);
        String[] keywords = HashFunction.getPrefixes(words);
        byte log2 = Utilities.log2(this.bitTableLength);
        for (int i = 0; i < keywords.length; ++i) {
            int hash = HashFunction.hash(keywords[i], log2);
            if (this.storage.get(hash)) continue;
            this.storage.set(hash);
        }
    }

    public void addIndivisible(String iString) {
        int hash = HashFunction.hash(iString, Utilities.log2(this.bitTableLength));
        if (!this.storage.get(hash)) {
            this.storage.set(hash);
        }
    }

    public void addAll(QueryRouteTable qrt) {
        this.storage.or(qrt.storage.resize(this.bitTableLength));
        this.storage.compact();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryRouteTable)) {
            return false;
        }
        QueryRouteTable other = (QueryRouteTable)o;
        if (this.bitTableLength != other.bitTableLength) {
            return false;
        }
        return this.storage.equals(other.storage);
    }

    public int hashCode() {
        return this.storage.hashCode() * 17;
    }

    public String toString() {
        return "QueryRouteTable: " + this.storage.toString();
    }

    public void reset(ResetTableMessage rtm) {
        this.initialize(rtm.getTableSize(), rtm.getInfinity());
    }

    public void patch(PatchTableMessage patch) throws BadPacketException {
        this.handlePatch(patch);
    }

    private void handlePatch(PatchTableMessage m) throws BadPacketException {
        if (this.sequenceSize != -1 && this.sequenceSize != m.getSequenceSize()) {
            throw new BadPacketException("Inconsistent seq size: " + m.getSequenceSize() + " vs. " + this.sequenceSize);
        }
        if (this.sequenceNumber == -1 ? m.getSequenceNumber() != 1 : this.sequenceNumber + 1 != m.getSequenceNumber()) {
            throw new BadPacketException("Inconsistent seq number: " + m.getSequenceNumber() + " vs. " + this.sequenceNumber);
        }
        byte[] data = m.getData();
        if (m.getCompressor() == 1) {
            try {
                if (m.getSequenceNumber() == 1) {
                    this.uncompressor = new Inflater();
                }
                assert (this.uncompressor != null) : "Null uncompressor.  Sequence: " + m.getSequenceNumber();
                data = this.uncompress(data);
            }
            catch (IOException e) {
                throw new BadPacketException("Couldn't uncompress data: " + e);
            }
        } else if (m.getCompressor() != 0) {
            throw new BadPacketException("Unknown compressor");
        }
        if (m.getEntryBits() == 4) {
            data = QueryRouteTable.unhalve(data);
        } else if (m.getEntryBits() != 8) {
            throw new BadPacketException("Unknown value for entry bits");
        }
        for (int i = 0; i < data.length; ++i) {
            if (this.nextPatch >= this.bitTableLength) {
                throw new BadPacketException("Tried to patch " + this.nextPatch + " on a bitTable of size " + this.bitTableLength);
            }
            if (data[i] < 0) {
                this.storage.set(this.nextPatch);
            } else if (data[i] > 0) {
                this.storage.clear(this.nextPatch);
            }
            ++this.nextPatch;
        }
        this.storage.compact();
        this.sequenceSize = m.getSequenceSize();
        if (m.getSequenceNumber() != m.getSequenceSize()) {
            this.sequenceNumber = m.getSequenceNumber();
        } else {
            this.sequenceNumber = -1;
            this.sequenceSize = -1;
            this.nextPatch = 0;
            if (this.uncompressor != null) {
                IOUtils.close(this.uncompressor);
                this.uncompressor = null;
            }
        }
    }

    public List<RouteTableMessage> encode(QueryRouteTable prev) {
        return this.encode(prev, true);
    }

    public List<RouteTableMessage> encode(QueryRouteTable prev, boolean allowCompression) {
        byte[] patchCompressed;
        LinkedList<RouteTableMessage> buf = new LinkedList<RouteTableMessage>();
        if (prev == null) {
            buf.add(new ResetTableMessage(this.bitTableLength, this.infinity));
        } else assert (prev.bitTableLength == this.bitTableLength) : "TODO: can't deal with tables of different lengths";
        byte[] data = new byte[this.bitTableLength];
        Utilities.fill(data, 0, this.bitTableLength, (byte)0);
        boolean needsPatch = false;
        if (prev != null) {
            if (!this.storage.equals(prev.storage)) {
                QRTTableStorage xOr = this.storage.clone();
                xOr.xor(prev.storage);
                Iterator i$ = xOr.iterator();
                while (i$.hasNext()) {
                    int i = (Integer)i$.next();
                    data[i] = this.storage.get(i) ? this.keywordPresent : this.keywordAbsent;
                    needsPatch = true;
                }
            }
        } else {
            Iterator i$ = this.storage.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                data[i] = this.keywordPresent;
                needsPatch = true;
            }
        }
        if (!needsPatch) {
            return buf;
        }
        byte bits = 8;
        if (this.keywordPresent >= -8 && this.keywordAbsent <= 7) {
            bits = 4;
            data = QueryRouteTable.halve(data);
        }
        byte compression = 0;
        if (allowCompression && (patchCompressed = IOUtils.deflate(data)).length < data.length) {
            data = patchCompressed;
            compression = 1;
        }
        int chunks = (int)Math.ceil((float)data.length / 4096.0f);
        int chunk = 1;
        for (int i = 0; i < data.length; i += 4096) {
            int stop = Math.min(i + 4096, data.length);
            buf.add(new PatchTableMessage((short)chunk, (short)chunks, compression, bits, data, i, stop));
            ++chunk;
        }
        return buf;
    }

    private byte[] uncompress(byte[] data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.uncompressor.setInput(data);
        try {
            int read;
            byte[] buf = new byte[1024];
            while ((read = this.uncompressor.inflate(buf)) != 0) {
                baos.write(buf, 0, read);
            }
            baos.flush();
            return baos.toByteArray();
        }
        catch (DataFormatException e) {
            throw new IOException("Bad deflate format");
        }
    }

    public byte[] getRawDump() {
        byte[] ret = new byte[this.bitTableLength / 8];
        Iterator i$ = this.storage.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            ret[i / 8] = (byte)(ret[i / 8] | 1 << 7 - i % 8);
        }
        return ret;
    }

    static byte[] halve(byte[] array) {
        byte[] ret = new byte[array.length / 2];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)(array[2 * i] << 4 | array[2 * i + 1] & 0xF);
        }
        return ret;
    }

    static byte[] unhalve(byte[] array) {
        byte[] ret = new byte[array.length * 2];
        for (int i = 0; i < array.length; ++i) {
            ret[2 * i] = (byte)(array[i] >> 4);
            ret[2 * i + 1] = QueryRouteTable.extendNibble((byte)(array[i] & 0xF));
        }
        return ret;
    }

    static byte extendNibble(byte b) {
        if ((b & 8) != 0) {
            return (byte)(0xF0 | b);
        }
        return b;
    }
}

