/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.messages.AbstractMessage;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.ResetTableMessage;
import java.io.IOException;
import java.io.OutputStream;

public abstract class RouteTableMessage
extends AbstractMessage {
    public static final byte RESET_VARIANT = 0;
    public static final byte PATCH_VARIANT = 1;
    private byte variant;

    protected RouteTableMessage(byte ttl, int length, byte variant) {
        super((byte)48, ttl, length);
        this.variant = variant;
    }

    protected void writePayload(OutputStream out) throws IOException {
        out.write(this.variant);
        this.writePayloadData(out);
    }

    protected abstract void writePayloadData(OutputStream var1) throws IOException;

    public static RouteTableMessage read(byte[] guid, byte ttl, byte hops, byte[] payload, Message.Network network) throws BadPacketException {
        if (payload.length < 2) {
            throw new BadPacketException("Payload too small");
        }
        byte variant = payload[0];
        switch (variant) {
            case 0: {
                return new ResetTableMessage(guid, ttl, hops, payload, network);
            }
            case 1: {
                return new PatchTableMessage(guid, ttl, hops, payload, network);
            }
        }
        throw new BadPacketException("Unknown table variant");
    }

    protected RouteTableMessage(byte[] guid, byte ttl, byte hops, int length, byte variant, Message.Network network) {
        super(guid, (byte)48, ttl, hops, length, network);
        this.variant = variant;
    }

    public byte getVariant() {
        return this.variant;
    }
}

