/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.rudp;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.rudp.messages.LimeRUDPMessageParser;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.observer.TransportListener;
import org.limewire.rudp.RUDPContext;
import org.limewire.rudp.RUDPSettings;
import org.limewire.rudp.UDPService;
import org.limewire.rudp.messages.RUDPMessageFactory;

@Singleton
class LimeRUDPContext
implements RUDPContext {
    private final RUDPMessageFactory rudpMessageFactory;
    private final RUDPSettings rudpSettings;
    private final UDPService udpService;
    private final NIODispatcher nioDispatcher;

    @Inject
    public LimeRUDPContext(UDPService udpService, RUDPMessageFactory rudpMessageFactory, RUDPSettings rudpSettings, MessageFactory messageFactory, NIODispatcher nioDispatcher) {
        this.udpService = udpService;
        this.rudpMessageFactory = rudpMessageFactory;
        this.rudpSettings = rudpSettings;
        this.nioDispatcher = nioDispatcher;
        LimeRUDPMessageParser parser = new LimeRUDPMessageParser(rudpMessageFactory);
        messageFactory.setParser((byte)65, parser);
    }

    public RUDPMessageFactory getMessageFactory() {
        return this.rudpMessageFactory;
    }

    public TransportListener getTransportListener() {
        return this.nioDispatcher.getTransportListener();
    }

    public RUDPSettings getRUDPSettings() {
        return this.rudpSettings;
    }

    public UDPService getUDPService() {
        return this.udpService;
    }
}

