/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.rudp;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.Message;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.limewire.io.NetworkUtils;
import org.limewire.rudp.messages.RUDPMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class LimeUDPService
implements org.limewire.rudp.UDPService {
    private final NetworkManager networkManager;
    private final Provider<UDPService> udpService;

    @Inject
    public LimeUDPService(NetworkManager networkManager, Provider<UDPService> udpService) {
        this.networkManager = networkManager;
        this.udpService = udpService;
    }

    @Override
    public InetAddress getStableListeningAddress() {
        InetAddress lip = null;
        try {
            lip = InetAddress.getByName(NetworkUtils.ip2string(this.networkManager.getNonForcedAddress()));
        }
        catch (UnknownHostException uhe) {
            try {
                lip = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return lip;
    }

    @Override
    public int getStableListeningPort() {
        return this.udpService.get().getStableUDPPort();
    }

    @Override
    public boolean isListening() {
        return this.udpService.get().isListening();
    }

    @Override
    public boolean isNATTraversalCapable() {
        return this.networkManager.canDoFWT();
    }

    @Override
    public void send(RUDPMessage message, SocketAddress address) {
        this.udpService.get().send((Message)((Object)message), (InetSocketAddress)address);
    }
}

