/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.search.HostData;
import java.net.UnknownHostException;
import java.util.Set;
import org.limewire.io.IpPort;
import org.limewire.io.IpPortImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostDataImpl
implements HostData {
    private final byte[] CLIENT_GUID;
    private final byte[] MESSAGE_GUID;
    private final int SPEED;
    private final boolean FIREWALLED;
    private final boolean BUSY;
    private final boolean MULTICAST;
    private final boolean CHAT_ENABLED;
    private final boolean BROWSE_HOST_ENABLED;
    private final boolean MEASURED_SPEED;
    private final int PORT;
    private final String IP;
    private final int QUALITY;
    private final String VENDOR_CODE;
    private final Set<? extends IpPort> PROXIES;
    private final boolean CAN_DO_FWTRANSFER;
    private final int FWT_VERSION;
    private final boolean TLS_CAPABLE;

    public HostDataImpl(byte[] clientGuid, byte[] messageGuid, int speed, boolean firewalled, boolean busy, boolean multicast, boolean chatEnabled, boolean browseHostEnabled, boolean measuredSpeed, String ip, int port, int quality, String vendorCode, Set<? extends IpPort> proxies, boolean canDoFw2Fw, int fwtVersion, boolean tlsCapable) {
        this.CLIENT_GUID = clientGuid;
        this.MESSAGE_GUID = messageGuid;
        this.SPEED = speed;
        this.FIREWALLED = firewalled;
        this.BUSY = busy;
        this.MULTICAST = multicast;
        this.CHAT_ENABLED = chatEnabled;
        this.BROWSE_HOST_ENABLED = browseHostEnabled;
        this.MEASURED_SPEED = measuredSpeed;
        this.IP = ip;
        this.PORT = port;
        this.QUALITY = quality;
        this.VENDOR_CODE = vendorCode;
        this.PROXIES = proxies;
        this.CAN_DO_FWTRANSFER = canDoFw2Fw;
        this.FWT_VERSION = fwtVersion;
        this.TLS_CAPABLE = tlsCapable;
    }

    @Override
    public byte[] getClientGUID() {
        return this.CLIENT_GUID;
    }

    @Override
    public String getVendorCode() {
        return this.VENDOR_CODE;
    }

    @Override
    public byte[] getMessageGUID() {
        return this.MESSAGE_GUID;
    }

    @Override
    public int getSpeed() {
        return this.SPEED;
    }

    @Override
    public int getQuality() {
        return this.QUALITY;
    }

    @Override
    public String getIP() {
        return this.IP;
    }

    @Override
    public int getPort() {
        return this.PORT;
    }

    @Override
    public boolean isFirewalled() {
        return this.FIREWALLED;
    }

    @Override
    public boolean isBusy() {
        return this.BUSY;
    }

    @Override
    public boolean isBrowseHostEnabled() {
        return this.BROWSE_HOST_ENABLED;
    }

    @Override
    public boolean isChatEnabled() {
        return this.CHAT_ENABLED;
    }

    @Override
    public boolean isMeasuredSpeed() {
        return this.MEASURED_SPEED;
    }

    @Override
    public boolean isReplyToMulticastQuery() {
        return this.MULTICAST;
    }

    @Override
    public Set<? extends IpPort> getPushProxies() {
        return this.PROXIES;
    }

    @Override
    public boolean supportsFWTransfer() {
        return this.CAN_DO_FWTRANSFER;
    }

    @Override
    public int getFWTVersionSupported() {
        return this.FWT_VERSION;
    }

    @Override
    public boolean isTLSCapable() {
        return this.TLS_CAPABLE;
    }

    public String toString() {
        try {
            return new IpPortImpl(this.IP, this.PORT).toString();
        }
        catch (UnknownHostException unknownHostException) {
            return super.toString();
        }
    }
}

