/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.google.inject.Singleton;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.search.QueryDispatcher;
import com.limegroup.gnutella.search.QueryHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableForSize;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionPoint;
import org.limewire.service.ErrorService;

@Singleton
public final class QueryDispatcherImpl
implements QueryDispatcher {
    @InspectableForSize(value="number of dispatched queries")
    private final Map<GUID, QueryHandler> QUERIES = new HashMap<GUID, QueryHandler>();
    @InspectionPoint(value="dispatched queries details")
    public final Inspectable queryDetail = new Inspectable(){

        public Object inspect() {
            ArrayList<Object> l = new ArrayList<Object>(QueryDispatcherImpl.this.QUERIES.size());
            for (QueryHandler qh : QueryDispatcherImpl.this.QUERIES.values()) {
                l.add(((Inspectable)((Object)qh)).inspect());
            }
            return l;
        }
    };
    @InspectableForSize(value="number of newly dispatched queries")
    private final List<QueryHandler> NEW_QUERIES = Collections.synchronizedList(new LinkedList());
    private final ExecutorService PROCESSOR = ExecutorsHelper.newProcessingQueue("QueryDispatcher");
    @InspectablePrimitive(value="querydispatcher active")
    private boolean _active;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQuery(QueryHandler handler) {
        handler.sendQuery();
        List<QueryHandler> list = this.NEW_QUERIES;
        synchronized (list) {
            this.NEW_QUERIES.add(handler);
            if (this.NEW_QUERIES.size() == 1 && !this._active) {
                this._active = true;
                this.PROCESSOR.execute(this);
            }
        }
    }

    public void removeReplyHandler(ReplyHandler handler) {
        if (!handler.isSupernodeClientConnection()) {
            return;
        }
        this.remove(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLeafResultsForQuery(GUID queryGUID, int numResults) {
        Map<GUID, QueryHandler> map = this.QUERIES;
        synchronized (map) {
            QueryHandler qh = this.QUERIES.get(queryGUID);
            if (qh != null) {
                qh.updateLeafResults(numResults);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLeafResultsForQuery(GUID queryGUID) {
        Map<GUID, QueryHandler> map = this.QUERIES;
        synchronized (map) {
            QueryHandler qh = this.QUERIES.get(queryGUID);
            if (qh == null) {
                return -1;
            }
            return qh.getNumResultsReportedByLeaf();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ReplyHandler handler) {
        QueryHandler qh;
        Iterator<QueryHandler> iter;
        Object object = this.NEW_QUERIES;
        synchronized (object) {
            iter = this.NEW_QUERIES.iterator();
            while (iter.hasNext()) {
                qh = iter.next();
                if (qh.getReplyHandler() != handler) continue;
                iter.remove();
            }
        }
        object = this.QUERIES;
        synchronized (object) {
            iter = this.QUERIES.values().iterator();
            while (iter.hasNext()) {
                qh = iter.next();
                if (qh.getReplyHandler() != handler) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(GUID guid) {
        QueryHandler qh;
        Iterator<QueryHandler> iter;
        Object object = this.NEW_QUERIES;
        synchronized (object) {
            iter = this.NEW_QUERIES.iterator();
            while (iter.hasNext()) {
                qh = iter.next();
                if (!qh.getGUID().equals(guid)) continue;
                iter.remove();
            }
        }
        object = this.QUERIES;
        synchronized (object) {
            iter = this.QUERIES.values().iterator();
            while (iter.hasNext()) {
                qh = iter.next();
                if (!qh.getGUID().equals(guid)) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            try {
                if (this.processQueries()) continue;
                List<QueryHandler> ignored = this.NEW_QUERIES;
                synchronized (ignored) {
                    if (this.NEW_QUERIES.isEmpty()) {
                        this._active = false;
                        return;
                    }
                    continue;
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processQueries() {
        Object object = this.NEW_QUERIES;
        synchronized (object) {
            Map<GUID, QueryHandler> map = this.QUERIES;
            synchronized (map) {
                for (QueryHandler qh : this.NEW_QUERIES) {
                    this.QUERIES.put(qh.getGUID(), qh);
                }
            }
            this.NEW_QUERIES.clear();
        }
        object = this.QUERIES;
        synchronized (object) {
            Iterator<QueryHandler> iter = this.QUERIES.values().iterator();
            while (iter.hasNext()) {
                QueryHandler handler = iter.next();
                handler.sendQuery();
                if (!handler.hasEnoughResults()) continue;
                iter.remove();
            }
            return !this.QUERIES.isEmpty();
        }
    }

    public void addToRemove(GUID g) {
        this.remove(g);
    }
}

