/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.ForMeReplyHandler;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.QueryRequestFactory;
import com.limegroup.gnutella.search.QueryHandlerFactory;
import com.limegroup.gnutella.search.QueryHandlerImpl;
import com.limegroup.gnutella.search.ResultCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class QueryHandlerFactoryImpl
implements QueryHandlerFactory {
    private static final double UP_RESULT_BUMP = 1.15;
    private static final int OLD_LEAF_RESULTS = 20;
    private static final int NEW_LEAF_RESULTS = 38;
    private final QueryRequestFactory queryRequestFactory;
    private final ForMeReplyHandler forMeReplyHandler;
    private final Provider<ConnectionManager> connectionManager;
    private final Provider<MessageRouter> messageRouter;

    @Inject
    public QueryHandlerFactoryImpl(QueryRequestFactory queryRequestFactory, ForMeReplyHandler forMeReplyHandler, Provider<ConnectionManager> connectionManager, Provider<MessageRouter> messageRouter) {
        this.queryRequestFactory = queryRequestFactory;
        this.forMeReplyHandler = forMeReplyHandler;
        this.connectionManager = connectionManager;
        this.messageRouter = messageRouter;
    }

    @Override
    public QueryHandlerImpl createHandler(QueryRequest query, ReplyHandler handler, ResultCounter counter) {
        return new QueryHandlerImpl(query, 150, handler, counter, this.queryRequestFactory, this.connectionManager.get(), this.messageRouter.get());
    }

    @Override
    public QueryHandlerImpl createHandlerForMe(QueryRequest query, ResultCounter counter) {
        return new QueryHandlerImpl(query, 172, this.forMeReplyHandler, counter, this.queryRequestFactory, this.connectionManager.get(), this.messageRouter.get());
    }

    @Override
    public QueryHandlerImpl createHandlerForOldLeaf(QueryRequest query, ReplyHandler handler, ResultCounter counter) {
        return new QueryHandlerImpl(query, 20, handler, counter, this.queryRequestFactory, this.connectionManager.get(), this.messageRouter.get());
    }

    @Override
    public QueryHandlerImpl createHandlerForNewLeaf(QueryRequest query, ReplyHandler handler, ResultCounter counter) {
        return new QueryHandlerImpl(query, 38, handler, counter, this.queryRequestFactory, this.connectionManager.get(), this.messageRouter.get());
    }
}

