/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.LimeProps;
import java.io.File;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.FileSetting;
import org.limewire.setting.FloatSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.LongSetting;
import org.limewire.setting.StringArraySetting;
import org.limewire.setting.StringSetting;
import org.limewire.util.OSUtils;

public class ApplicationSettings
extends LimeProps {
    public static final StringSetting CLIENT_ID = FACTORY.createStringSetting("CLIENT_ID", "");
    @InspectablePrimitive(value="average application uptime")
    public static final IntSetting AVERAGE_UPTIME = FACTORY.createExpirableIntSetting("AVERAGE_UPTIME", 0);
    @InspectablePrimitive(value="last n application uptimes")
    public static final StringArraySetting LAST_N_UPTIMES = FACTORY.createStringArraySetting("LAST_N_UPTIMES", new String[0]);
    @InspectablePrimitive(value="total application uptime")
    public static final IntSetting TOTAL_UPTIME = FACTORY.createIntSetting("TOTAL_UPTIME", 0);
    public static final LongSetting AVERAGE_CONNECTION_TIME = FACTORY.createExpirableLongSetting("AVERAGE_CONNECTION_TIME", 0L);
    public static final LongSetting TOTAL_CONNECTION_TIME = FACTORY.createLongSetting("TOTAL_CONNECTION_TIME", 0L);
    public static final IntSetting TOTAL_CONNECTIONS = FACTORY.createIntSetting("TOTAL_CONNECTIONS", 0);
    @InspectablePrimitive(value="number of sessions")
    public static final IntSetting SESSIONS = FACTORY.createIntSetting("SESSIONS", 1);
    @InspectablePrimitive(value="last shutdown time")
    public static final LongSetting LAST_SHUTDOWN_TIME = FACTORY.createLongSetting("LAST_SHUTDOWN_TIME", 0L);
    @InspectablePrimitive(value="previous shutdown was graceful")
    public static final BooleanSetting PREVIOUS_SHUTDOWN_WAS_GRACEFUL = FACTORY.createBooleanSetting("PREVIOUS_SHUTDOWN_WAS_GRACEFUL", true);
    public static final BooleanSetting CURRENTLY_RUNNING = FACTORY.createBooleanSetting("CURRENTLY_RUNNING", false);
    public static final FloatSetting FRACTIONAL_UPTIME = FACTORY.createFloatSetting("FRACTIONAL_UPTIME", 0.0f);
    public static final BooleanSetting INSTALLED = FACTORY.createBooleanSetting("INSTALLED", false);
    @InspectablePrimitive(value="application width")
    public static final IntSetting APP_WIDTH = FACTORY.createIntSetting("APP_WIDTH", 840);
    @InspectablePrimitive(value="application height")
    public static final IntSetting APP_HEIGHT = FACTORY.createIntSetting("APP_HEIGHT", 800);
    public static final BooleanSetting RUN_ONCE = FACTORY.createBooleanSetting("RUN_ONCE", false);
    public static final IntSetting WINDOW_X = (IntSetting)FACTORY.createIntSetting("WINDOW_X", 0).setAlwaysSave(true);
    public static final IntSetting WINDOW_Y = (IntSetting)FACTORY.createIntSetting("WINDOW_Y", 0).setAlwaysSave(true);
    @InspectablePrimitive(value="is application maximized")
    public static final BooleanSetting MAXIMIZE_WINDOW = FACTORY.createBooleanSetting("MAXIMIZE_WINDOW", false);
    public static final BooleanSetting MINIMIZE_TO_TRAY = FACTORY.createBooleanSetting("MINIMIZE_TO_TRAY", OSUtils.supportsTray());
    public static final BooleanSetting DISPLAY_TRAY_ICON = FACTORY.createBooleanSetting("DISPLAY_TRAY_ICON", true);
    public static final BooleanSetting SHUTDOWN_AFTER_TRANSFERS = FACTORY.createBooleanSetting("SHUTDOWN_AFTER_TRANSFERS", OSUtils.isMacOSX() ? false : !OSUtils.supportsTray());
    public static final StringSetting LANGUAGE = FACTORY.createStringSetting("LANGUAGE", System.getProperty("user.language", ""));
    public static final StringSetting COUNTRY = FACTORY.createStringSetting("COUNTRY", System.getProperty("user.country", ""));
    public static final StringSetting LOCALE_VARIANT = FACTORY.createStringSetting("LOCALE_VARIANT", System.getProperty("user.variant", ""));
    public static final BooleanSetting MONITOR_VIEW_ENABLED = FACTORY.createBooleanSetting("MONITOR_VIEW_ENABLED", true);
    public static final BooleanSetting CONNECTION_VIEW_ENABLED = FACTORY.createBooleanSetting("CONNECTION_VIEW_ENABLED", false);
    public static final BooleanSetting LIBRARY_VIEW_ENABLED = FACTORY.createBooleanSetting("LIBRARY_VIEW_ENABLED", true);
    public static final BooleanSetting CONSOLE_VIEW_ENABLED = FACTORY.createBooleanSetting("CONSOLE_VIEW_ENABLED", false);
    public static final BooleanSetting LOGGING_VIEW_ENABLED = FACTORY.createBooleanSetting("LOGGING_VIEW_ENABLED", false);
    public static final BooleanSetting SWT_BROWSER_VIEW_ENABLED = FACTORY.createBooleanSetting("SWT_BROWSER_VIEW_ENABLED", true);
    public static final StringSetting JAR_NAME = FACTORY.createStringSetting("JAR_NAME", "LimeWire.jar");
    public static final StringSetting CLASSPATH = FACTORY.createStringSetting("CLASSPATH", JAR_NAME.getValue());
    public static final BooleanSetting SERVER = FACTORY.createBooleanSetting("SERVER", false);
    public static final BooleanSetting AUTOMATIC_MANUAL_GC = FACTORY.createBooleanSetting("AUTOMATIC_MANUAL_GC", OSUtils.isMacOSX());
    public static final StringSetting DEFAULT_LOCALE = FACTORY.createStringSetting("DEFAULT_LOCALE", "en");
    public static final BooleanSetting MAGNET_CLIPBOARD_LISTENER = FACTORY.createBooleanSetting("MAGNET_CLIPBOARD_LISTENER", !OSUtils.isWindows() && !OSUtils.isAnyMac());
    public static final BooleanSetting HANDLE_MAGNETS = FACTORY.createBooleanSetting("HANDLE_MAGNETS", true);
    public static final BooleanSetting HANDLE_TORRENTS = FACTORY.createBooleanSetting("HANDLE_TORRENTS", true);
    public static final BooleanSetting USE_SECURE_RESULTS = FACTORY.createBooleanSetting("USE_SECURE_RESULTS", true);
    public static final FileSetting LAST_FILECHOOSER_DIRECTORY = FACTORY.createFileSetting("LAST_FILECHOOSER_DIR", new File("")).setAlwaysSave(true);
    public static final BooleanSetting USAGE_STATS = FACTORY.createBooleanSetting("USAGE_STATS", false);
    public static final BooleanSetting INITIALIZE_SIMPP = FACTORY.createBooleanSetting("INITIALIZE_SIMPP", true);

    private ApplicationSettings() {
    }

    public static String getLanguage() {
        String lc = LANGUAGE.getValue();
        String cc = COUNTRY.getValue();
        String lv = LOCALE_VARIANT.getValue();
        String lang = lc;
        if (cc != null && !cc.equals("")) {
            lang = lang + "_" + cc;
        }
        if (lv != null && !lv.equals("")) {
            lang = lang + "_" + lv;
        }
        return lang;
    }
}

