/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.LimeProps;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.setting.BooleanSetting;

public class SSLSettings
extends LimeProps {
    public static final BooleanSetting TLS_INCOMING = FACTORY.createBooleanSetting("TLS_INCOMING", true);
    public static final BooleanSetting TLS_OUTGOING = FACTORY.createBooleanSetting("TLS_OUTGOING", true);
    public static final BooleanSetting IGNORE_SSL_EXCEPTIONS = FACTORY.createRemoteBooleanSetting("IGNORE_SSL_EXCEPTIONS", true, "TLS.ignoreException");
    private static volatile boolean tlsDisabled;
    @InspectablePrimitive(value="reason tls failed")
    private static volatile String tlsDisabledReason;

    private SSLSettings() {
    }

    public static void disableTLS(Throwable reason) {
        tlsDisabled = true;
        if (reason != null) {
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            reason.printStackTrace(pw);
            pw.flush();
            tlsDisabledReason = writer.getBuffer().toString();
        } else {
            tlsDisabledReason = null;
        }
    }

    public static boolean isTLSDisabled() {
        return tlsDisabled;
    }

    public static boolean isIncomingTLSEnabled() {
        return !tlsDisabled && TLS_INCOMING.getValue();
    }

    public static boolean isOutgoingTLSEnabled() {
        return !tlsDisabled && TLS_OUTGOING.getValue();
    }
}

