/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.LimeWireSettings;
import java.util.HashMap;
import java.util.Map;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.Setting;
import org.limewire.setting.SettingsFactory;

public final class TablesHandler
extends LimeWireSettings {
    private static final TablesHandler INSTANCE = new TablesHandler();
    private static final SettingsFactory FACTORY = INSTANCE.getFactory();
    private static final String WIDTH = "_WIDTH";
    private static final String ORDER = "_ORDER";
    private static final String VISBL = "_VISIBLE";
    private static final Map<String, Setting> SETS = new HashMap<String, Setting>();

    public static TablesHandler instance() {
        return INSTANCE;
    }

    private TablesHandler() {
        super("tables.props", "LimeWire tables file");
    }

    public static IntSetting getWidth(String id, int def) {
        return TablesHandler.getSetting(id + WIDTH, def);
    }

    public static IntSetting getOrder(String id, int def) {
        return TablesHandler.getSetting(id + ORDER, def);
    }

    public static BooleanSetting getVisibility(String id, boolean def) {
        return TablesHandler.getSetting(id + VISBL, def);
    }

    private static IntSetting getSetting(String id, int def) {
        IntSetting set = (IntSetting)SETS.get(id);
        if (set == null) {
            set = FACTORY.createIntSetting(id, def);
            SETS.put(id, set);
        }
        return set;
    }

    private static BooleanSetting getSetting(String id, boolean def) {
        BooleanSetting set = (BooleanSetting)SETS.get(id);
        if (set == null) {
            set = FACTORY.createBooleanSetting(id, def);
            SETS.put(id, set);
        }
        return set;
    }
}

