/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.LimeProps;
import java.awt.Dimension;
import java.awt.Toolkit;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.StringSetting;

public final class UISettings
extends LimeProps {
    public static final BooleanSetting AUTOCOMPLETE_ENABLED = FACTORY.createBooleanSetting("AUTOCOMPLETE_ENABLED", true);
    public static final BooleanSetting SEARCH_RESULT_FILTERS = FACTORY.createBooleanSetting("SEARCH_RESULT_FILTERS", true);
    public static final BooleanSetting SMALL_ICONS = FACTORY.createBooleanSetting("UI_SMALL_ICONS", UISettings.isResolutionLow());
    public static final BooleanSetting TEXT_WITH_ICONS = FACTORY.createBooleanSetting("UI_TEXT_WITH_ICONS", true);
    public static final BooleanSetting UI_GROUP_RESULTS = FACTORY.createBooleanSetting("UI_GROUP_RESULTS", true);
    public static final BooleanSetting UI_ADD_REPLY_ALT_LOCS = FACTORY.createBooleanSetting("UI_ADD_REPLY_ALT_LOCS", true);
    public static final BooleanSetting UI_MONITOR_SHOW_INCOMING_SEARCHES = FACTORY.createBooleanSetting("UI_MONITOR_SHOW_INCOMING_SEARCHES", false);
    public static final IntSetting UI_LIBRARY_TREE_DIVIDER_LOCATION = FACTORY.createIntSetting("UI_LIBRARY_TREE_DIVIDER_LOCATION", -1);
    public static final IntSetting UI_LIBRARY_PLAY_LIST_TAB_DIVIDER_LOCATION = FACTORY.createIntSetting("UI_LIBRARY_PLAY_LIST_TAB_DIVIDER_LOCATION", 300);
    public static final IntSetting UI_MONITOR_UPLOAD_TAB_DIVIDER_LOCATION = FACTORY.createIntSetting("UI_MONITOR_UPLOAD_TAB_DIVIDER_LOCATION", 300);
    public static final BooleanSetting PRELOAD_NATIVE_ICONS = FACTORY.createBooleanSetting("PRELOAD_NATIVE_ICONS", true);
    public static final IntSetting UI_OPTIONS_DIALOG_WIDTH = FACTORY.createIntSetting("UI_OPTIONS_DIALOG_WIDTH", 600);
    public static final IntSetting UI_OPTIONS_DIALOG_HEIGHT = FACTORY.createIntSetting("UI_OPTIONS_DIALOG_HEIGHT", 500);
    public static final BooleanSetting SHOW_NOTIFICATIONS = FACTORY.createBooleanSetting("SHOW_NOTIFICATIONS", true);
    private static final BooleanSetting USE_NETWORK_IMAGES = FACTORY.createRemoteBooleanSetting("USE_NETWORK_IMAGES", true, "UI.useNetworkImages");
    public static final ImageInfo INTRO_IMAGE_INFO = new ImageInfoImpl(true);
    public static final ImageInfo AFTER_SEARCH_IMAGE_INFO = new ImageInfoImpl(false);

    private UISettings() {
    }

    private static boolean isResolutionLow() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return screenSize.width <= 800 || screenSize.height <= 600;
    }

    private static class ImageInfoImpl
    implements ImageInfo {
        private final boolean intro;
        private final StringSetting imageUrl;
        private final BooleanSetting proShowPic;
        private final BooleanSetting canLink;
        private final StringSetting localLink;
        private final StringSetting networkLink;

        ImageInfoImpl(boolean intro) {
            this.intro = intro;
            this.imageUrl = LimeProps.FACTORY.createRemoteStringSetting(this.key("URL"), "http://clientpix.limewire.com/pix/" + (intro ? "intro" : "afterSearch"), this.remoteKey("Url"));
            this.proShowPic = LimeProps.FACTORY.createRemoteBooleanSetting(this.key("PRO_SHOW"), false, this.remoteKey("ProShow"));
            this.canLink = LimeProps.FACTORY.createRemoteBooleanSetting(this.key("HAS_LINK"), true, this.remoteKey("CanLink"));
            this.localLink = LimeProps.FACTORY.createRemoteStringSetting(this.key("LOCAL_LINK"), intro ? "" : "http://www.limewire.com/inclient/?stage=after&resource=local", this.remoteKey("ClickLinkLocal"));
            this.networkLink = LimeProps.FACTORY.createRemoteStringSetting(this.key("NETWORK_LINK"), intro ? "http://www.limewire.com/inclient/?stage=intro&resource=network" : "http://www.limewire.com/inclient/?stage=after&resource=network", this.remoteKey("ClickLink"));
        }

        private String key(String key) {
            return this.intro ? "INTRO_" + key : "AFTER_SEARCH_" + key;
        }

        private String remoteKey(String key) {
            return this.intro ? "UI.intro" + key : "UI.afterSearch" + key;
        }

        public boolean canLink() {
            return this.canLink.getValue();
        }

        public boolean canProShowPic() {
            return this.proShowPic.getValue();
        }

        public String getImageUrl() {
            return this.imageUrl.getValue();
        }

        public String getLocalLinkUrl() {
            return this.localLink.getValue();
        }

        public String getNetworkLinkUrl() {
            return this.networkLink.getValue();
        }

        public boolean useNetworkImage() {
            return USE_NETWORK_IMAGES.getValue();
        }

        public boolean isIntro() {
            return this.intro;
        }
    }

    public static interface ImageInfo {
        public String getImageUrl();

        public boolean canProShowPic();

        public boolean canLink();

        public String getLocalLinkUrl();

        public String getNetworkLinkUrl();

        public boolean useNetworkImage();

        public boolean isIntro();
    }
}

