/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.limegroup.gnutella.ApplicationServices;
import com.limegroup.gnutella.NetworkUpdateSanityChecker;
import com.limegroup.gnutella.ReplyHandler;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientListener;
import com.limegroup.gnutella.http.HttpExecutor;
import com.limegroup.gnutella.settings.SimppSettingsManager;
import com.limegroup.gnutella.settings.UpdateSettings;
import com.limegroup.gnutella.simpp.SimppDataProvider;
import com.limegroup.gnutella.simpp.SimppDataVerifier;
import com.limegroup.gnutella.simpp.SimppListener;
import com.limegroup.gnutella.simpp.SimppManager;
import com.limegroup.gnutella.simpp.SimppParser;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.AbstractHttpParams;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.io.IOUtils;
import org.limewire.util.Clock;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class SimppManagerImpl
implements SimppManager {
    private static final Log LOG = LogFactory.getLog(SimppManagerImpl.class);
    private static int MIN_VERSION = 3;
    private static final String FILENAME = "simpp.xml";
    private static final Random RANDOM = new Random();
    private static final int IGNORE_ID = Integer.MAX_VALUE;
    private volatile byte[] _lastBytes = new byte[0];
    private volatile String _lastString = "";
    private volatile int _lastId = MIN_VERSION;
    private final HttpRequestControl httpRequestControl = new HttpRequestControl();
    private final List<SimppListener> listeners = new CopyOnWriteArrayList<SimppListener>();
    private final CopyOnWriteArrayList<SimppSettingsManager> simppSettingsManagers;
    private final Provider<NetworkUpdateSanityChecker> networkUpdateSanityChecker;
    private final ApplicationServices applicationServices;
    private final Clock clock;
    private final Provider<HttpExecutor> httpExecutor;
    private final ScheduledExecutorService backgroundExecutor;
    private final Provider<HttpParams> defaultParams;
    private final SimppDataProvider simppDataProvider;
    private volatile List<String> maxedUpdateList = Arrays.asList("http://simpp1.limewire.com/v2/simpp.def", "http://simpp2.limewire.com/v2/simpp.def", "http://simpp3.limewire.com/v2/simpp.def", "http://simpp4.limewire.com/v2/simpp.def", "http://simpp5.limewire.com/v2/simpp.def", "http://simpp6.limewire.com/v2/simpp.def", "http://simpp7.limewire.com/v2/simpp.def", "http://simpp8.limewire.com/v2/simpp.def", "http://simpp9.limewire.com/v2/simpp.def", "http://simpp10.limewire.com/v2/simpp.def");
    private volatile int minMaxHttpRequestDelay = 60000;
    private volatile int maxMaxHttpRequestDelay = 1800000;
    private volatile int silentPeriodForMaxHttpRequest = 300000;

    @Inject
    public SimppManagerImpl(Provider<NetworkUpdateSanityChecker> networkUpdateSanityChecker, Clock clock, ApplicationServices applicationServices, Provider<HttpExecutor> httpExecutor, @Named(value="backgroundExecutor") ScheduledExecutorService backgroundExecutor, @Named(value="defaults") Provider<HttpParams> defaultParams, SimppDataProvider simppDataProvider) {
        this.networkUpdateSanityChecker = networkUpdateSanityChecker;
        this.clock = clock;
        this.applicationServices = applicationServices;
        this.simppSettingsManagers = new CopyOnWriteArrayList();
        this.httpExecutor = httpExecutor;
        this.backgroundExecutor = backgroundExecutor;
        this.defaultParams = defaultParams;
        this.simppDataProvider = simppDataProvider;
    }

    List<String> getMaxUrls() {
        return this.maxedUpdateList;
    }

    void setMaxUrls(List<String> urls) {
        this.maxedUpdateList = urls;
    }

    int getMinHttpRequestUpdateDelayForMaxFailover() {
        return this.minMaxHttpRequestDelay;
    }

    int getMaxHttpRequestUpdateDelayForMaxFailover() {
        return this.maxMaxHttpRequestDelay;
    }

    void setMinHttpRequestUpdateDelayForMaxFailover(int min) {
        this.minMaxHttpRequestDelay = min;
    }

    void setMaxHttpRequestUpdateDelayForMaxFailover(int max) {
        this.maxMaxHttpRequestDelay = max;
    }

    int getSilentPeriodForMaxHttpRequest() {
        return this.silentPeriodForMaxHttpRequest;
    }

    void setSilentPeriodForMaxHttpRequest(int silentPeriodForMaxHttpRequest) {
        this.silentPeriodForMaxHttpRequest = silentPeriodForMaxHttpRequest;
    }

    @Override
    public void initialize() {
        LOG.trace("Initializing SimppManager");
        this.backgroundExecutor.execute(new Runnable(){

            public void run() {
                SimppManagerImpl.this.handleDataInternal(FileUtils.readFileFully(new File(CommonUtils.getUserSettingsDir(), SimppManagerImpl.FILENAME)), UpdateType.FROM_DISK, null);
                SimppManagerImpl.this.handleDataInternal(SimppManagerImpl.this.simppDataProvider.getDefaultData(), UpdateType.FROM_DISK, null);
            }
        });
    }

    @Override
    public int getVersion() {
        return this._lastId;
    }

    @Override
    public byte[] getSimppBytes() {
        return this._lastBytes;
    }

    @Override
    public String getPropsString() {
        return this._lastString;
    }

    @Override
    public void addSimppSettingsManager(SimppSettingsManager simppSettingsManager) {
        this.simppSettingsManagers.add(simppSettingsManager);
    }

    @Override
    public List<SimppSettingsManager> getSimppSettingsManagers() {
        return this.simppSettingsManagers;
    }

    @Override
    public void addListener(SimppListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(SimppListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void checkAndUpdate(final ReplyHandler handler, final byte[] data) {
        if (data != null) {
            this.backgroundExecutor.execute(new Runnable(){

                public void run() {
                    LOG.trace("Parsing new data...");
                    SimppManagerImpl.this.handleDataInternal(data, UpdateType.FROM_NETWORK, handler);
                }
            });
        }
    }

    private void handleDataInternal(byte[] data, UpdateType updateType, ReplyHandler handler) {
        if (data == null) {
            if (updateType == UpdateType.FROM_NETWORK && handler != null) {
                this.networkUpdateSanityChecker.get().handleInvalidResponse(handler, NetworkUpdateSanityChecker.RequestType.SIMPP);
            }
            LOG.warn("No data to handle.");
            return;
        }
        SimppDataVerifier verifier = new SimppDataVerifier(data);
        if (!verifier.verifySource()) {
            if (updateType == UpdateType.FROM_NETWORK && handler != null) {
                this.networkUpdateSanityChecker.get().handleInvalidResponse(handler, NetworkUpdateSanityChecker.RequestType.SIMPP);
            }
            LOG.warn("Couldn't verify signature on data.");
            return;
        }
        if (updateType == UpdateType.FROM_NETWORK && handler != null) {
            this.networkUpdateSanityChecker.get().handleValidResponse(handler, NetworkUpdateSanityChecker.RequestType.SIMPP);
        }
        SimppParser parser = null;
        try {
            parser = new SimppParser(verifier.getVerifiedData());
        }
        catch (IOException iox) {
            LOG.error("IOX parsing simpp data", iox);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Got data with version: " + parser.getVersion() + " from: " + (Object)((Object)updateType) + ", current version is: " + this._lastId);
        }
        switch (updateType) {
            case FROM_NETWORK: {
                if (parser.getVersion() == Integer.MAX_VALUE) {
                    if (this._lastId == Integer.MAX_VALUE) break;
                    this.doHttpMaxFailover();
                    break;
                }
                if (parser.getVersion() <= this._lastId) break;
                this.storeAndUpdate(data, parser, updateType);
                break;
            }
            case FROM_DISK: {
                if (parser.getVersion() <= this._lastId) break;
                this.storeAndUpdate(data, parser, updateType);
                break;
            }
            case FROM_HTTP: {
                if (parser.getVersion() < this._lastId) break;
                this.storeAndUpdate(data, parser, updateType);
            }
        }
    }

    private void storeAndUpdate(byte[] data, SimppParser parser, UpdateType updateType) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Retrieved new data from: " + (Object)((Object)updateType) + ", storing & updating");
        }
        if (parser.getVersion() == Integer.MAX_VALUE && updateType == UpdateType.FROM_NETWORK) {
            throw new IllegalStateException("shouldn't be here!");
        }
        if (updateType == UpdateType.FROM_NETWORK && this.httpRequestControl.isRequestPending()) {
            return;
        }
        this._lastId = parser.getVersion();
        this._lastBytes = data;
        this._lastString = parser.getPropsData();
        if (updateType != UpdateType.FROM_DISK) {
            FileUtils.verySafeSave(CommonUtils.getUserSettingsDir(), FILENAME, data);
        }
        for (SimppSettingsManager ssm : this.simppSettingsManagers) {
            ssm.updateSimppSettings(this._lastString);
        }
        for (SimppListener listener : this.listeners) {
            listener.simppUpdated(this._lastId);
        }
    }

    private void doHttpMaxFailover() {
        long maxTimeAgo = this.clock.now() - (long)this.silentPeriodForMaxHttpRequest;
        if (!this.httpRequestControl.requestQueued(HttpRequestControl.RequestReason.MAX) && UpdateSettings.LAST_SIMPP_FAILOVER.getValue() < maxTimeAgo) {
            int rndDelay = RANDOM.nextInt(this.maxMaxHttpRequestDelay) + this.minMaxHttpRequestDelay;
            final String rndUri = this.maxedUpdateList.get(RANDOM.nextInt(this.maxedUpdateList.size()));
            LOG.debug("Scheduling http max failover in: " + rndDelay + ", to: " + rndUri);
            this.backgroundExecutor.schedule(new Runnable(){

                public void run() {
                    String url = rndUri;
                    try {
                        SimppManagerImpl.this.launchHTTPUpdate(url);
                    }
                    catch (URISyntaxException e) {
                        SimppManagerImpl.this.httpRequestControl.requestFinished();
                        SimppManagerImpl.this.httpRequestControl.cancelRequest();
                        LOG.warn("uri failure", e);
                    }
                }
            }, (long)rndDelay, TimeUnit.MILLISECONDS);
        } else {
            LOG.debug("Ignoring http max failover.");
        }
    }

    private void launchHTTPUpdate(String url) throws URISyntaxException {
        if (!this.httpRequestControl.isRequestPending()) {
            return;
        }
        LOG.debug("about to issue http request method");
        HttpGet get = new HttpGet(LimeWireUtils.addLWInfoToUrl(url, this.applicationServices.getMyGUID()));
        get.addHeader("User-Agent", LimeWireUtils.getHttpServer());
        get.addHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
        this.httpRequestControl.requestActive();
        AbstractHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(params, 10000);
        HttpConnectionParams.setSoTimeout(params, 10000);
        params = new DefaultedHttpParams(params, this.defaultParams.get());
        this.httpExecutor.get().execute(get, params, new RequestHandler());
    }

    @Override
    public byte[] getOldUpdateResponse() {
        return this.simppDataProvider.getOldUpdateResponse();
    }

    private static class HttpRequestControl {
        private final AtomicBoolean requestQueued = new AtomicBoolean(false);
        private final AtomicBoolean requestActive = new AtomicBoolean(false);
        private volatile RequestReason requestReason;

        private HttpRequestControl() {
        }

        boolean isRequestPending() {
            return this.requestActive.get() || this.requestQueued.get();
        }

        boolean requestQueued(RequestReason reason) {
            boolean prior = this.requestQueued.getAndSet(true);
            if (!prior || reason == RequestReason.MAX) {
                this.requestReason = reason;
            }
            return prior || this.requestActive.get();
        }

        void requestActive() {
            this.requestActive.set(true);
            this.requestQueued.set(false);
        }

        RequestReason getRequestReason() {
            return this.requestReason;
        }

        void cancelRequest() {
            this.requestQueued.set(false);
        }

        void requestFinished() {
            this.requestActive.set(false);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum RequestReason {
            MAX;

        }
    }

    private class RequestHandler
    implements HttpClientListener {
        private RequestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean requestComplete(HttpUriRequest request, HttpResponse response) {
            byte[] inflated;
            LOG.debug("http request method succeeded");
            UpdateSettings.LAST_SIMPP_FAILOVER.setValue(SimppManagerImpl.this.clock.now());
            try {
                if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300) {
                    throw new IOException("bad code " + response.getStatusLine().getStatusCode());
                }
                byte[] resp = null;
                if (response.getEntity() != null) {
                    resp = IOUtils.readFully(response.getEntity().getContent());
                }
                if (resp == null || resp.length == 0) {
                    throw new IOException("bad body");
                }
                inflated = IOUtils.inflate(resp);
            }
            catch (IOException failed) {
                SimppManagerImpl.this.httpRequestControl.requestFinished();
                LOG.warn("couldn't fetch data ", failed);
                boolean bl = false;
                return bl;
            }
            finally {
                ((HttpExecutor)SimppManagerImpl.this.httpExecutor.get()).releaseResources(response);
            }
            SimppManagerImpl.this.backgroundExecutor.execute(new Runnable(){

                public void run() {
                    SimppManagerImpl.this.httpRequestControl.requestFinished();
                    LOG.trace("Parsing new data...");
                    SimppManagerImpl.this.handleDataInternal(inflated, UpdateType.FROM_HTTP, null);
                }
            });
            return false;
        }

        public boolean requestFailed(HttpUriRequest request, HttpResponse response, IOException exc) {
            LOG.warn("http failover failed", exc);
            SimppManagerImpl.this.httpRequestControl.requestFinished();
            UpdateSettings.LAST_SIMPP_FAILOVER.setValue(SimppManagerImpl.this.clock.now());
            ((HttpExecutor)SimppManagerImpl.this.httpExecutor.get()).releaseResources(response);
            return false;
        }

        public boolean allowRequest(HttpUriRequest request) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum UpdateType {
        FROM_NETWORK,
        FROM_DISK,
        FROM_HTTP;

    }
}

