/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.spam.Token;
import com.limegroup.gnutella.spam.Tokenizer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectionPoint;
import org.limewire.io.IOUtils;
import org.limewire.util.CommonUtils;
import org.limewire.util.GenericsUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class RatingTable {
    private static final Log LOG = LogFactory.getLog(Tokenizer.class);
    private static final int MAX_SIZE = 50000;
    private final Map<Token, Token> _tokenMap;
    private final Tokenizer tokenizer;
    @InspectionPoint(value="spam rating table token hashes")
    private final Inspectable TOKEN_HASH = new Inspectable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object inspect() {
            RatingTable ratingTable = RatingTable.this;
            synchronized (ratingTable) {
                HashMap<String, Object> ret = new HashMap<String, Object>();
                ret.put("ver", 1);
                float spamTreshold = Math.max(SearchSettings.FILTER_SPAM_RESULTS.getValue(), SearchSettings.QUERY_SPAM_CUTOFF.getValue());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream daos = new DataOutputStream(baos);
                try {
                    Token t;
                    float rating;
                    Iterator i$ = RatingTable.this._tokenMap.values().iterator();
                    while (i$.hasNext() && !((rating = (t = (Token)i$.next()).getRating()) < spamTreshold)) {
                        daos.writeFloat(rating);
                        daos.writeInt(t.hashCode());
                    }
                    daos.flush();
                    daos.close();
                    ret.put("dump", baos.toByteArray());
                }
                catch (IOException impossible) {
                    ret.put("error", impossible.toString());
                }
                return ret;
            }
        }
    };

    @Inject
    RatingTable(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
        this._tokenMap = this.readData();
        for (Token token : this._tokenMap.values()) {
            tokenizer.initialize(token);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("size of tokenSet " + this._tokenMap.size());
        }
    }

    synchronized void clear() {
        this._tokenMap.clear();
    }

    float getRating(RemoteFileDesc desc) {
        float ret = this.getRating(this.lookup(this.tokenizer.getTokens(desc)));
        if (LOG.isDebugEnabled()) {
            LOG.debug(desc.toString() + " rated " + ret);
        }
        return ret;
    }

    float getRating(Token[] tokens) {
        float rating = 1.0f;
        for (int i = 0; i < tokens.length && rating > 0.0f; rating *= 1.0f - tokens[i].getRating(), ++i) {
        }
        float bad = SearchSettings.FILTER_SPAM_RESULTS.getValue();
        if ((rating = 1.0f - rating) >= bad && rating <= 0.995f) {
            this.markInternal(tokens, Token.Rating.PROGRAM_MARKED_SPAM);
        } else if (rating <= 1.0f - bad) {
            this.markInternal(tokens, Token.Rating.PROGRAM_MARKED_GOOD);
        }
        return rating;
    }

    void mark(RemoteFileDesc[] descs, Token.Rating rating) {
        this.markInternal(this.lookup(this.tokenizer.getTokens(descs)), rating);
    }

    void mark(RemoteFileDesc desc, Token.Rating rating) {
        this.markInternal(this.lookup(this.tokenizer.getTokens(desc)), rating);
    }

    void mark(QueryRequest qr, Token.Rating rating) {
        this.markInternal(this.lookup(this.tokenizer.getTokens(qr)), rating);
    }

    private void markInternal(Token[] tokens, Token.Rating rating) {
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i].rate(rating);
        }
    }

    private Token[] lookup(Token[] tokens) {
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = this.lookup(tokens[i]);
        }
        return tokens;
    }

    private synchronized Token lookup(Token token) {
        Token stored = this._tokenMap.get(token);
        if (stored == null) {
            this._tokenMap.put(token, token);
            this.checkSize();
            stored = token;
        }
        return stored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Token, Token> readData() {
        Map<Token, Token> map;
        ObjectInputStream is = null;
        try {
            is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(RatingTable.getSpamDat())));
            map = GenericsUtils.scanForMap(is.readObject(), Token.class, Token.class, GenericsUtils.ScanMode.REMOVE);
        }
        catch (Throwable someKindOfError) {
            try {
                HashMap<Token, Token> hashMap = new HashMap<Token, Token>();
                return hashMap;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.close(is);
            }
        }
        IOUtils.close(is);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        HashMap<Token, Token> copy;
        RatingTable ratingTable = this;
        synchronized (ratingTable) {
            if (this._tokenMap.size() > 50000) {
                this.pruneEntries();
            }
            copy = new HashMap<Token, Token>(this._tokenMap);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("size of tokenMap " + copy.size());
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(RatingTable.getSpamDat())));
            oos.writeObject(copy);
            oos.flush();
            IOUtils.close(oos);
        }
        catch (IOException iox) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("saving rating table failed", iox);
            }
        }
        finally {
            IOUtils.close(oos);
        }
    }

    public synchronized void ageAndSave() {
        for (Token token : this._tokenMap.values()) {
            token.incrementAge();
        }
        this.save();
    }

    private synchronized void checkSize() {
        if (this._tokenMap.size() < 100000) {
            return;
        }
        this.pruneEntries();
    }

    private void pruneEntries() {
        int tokensToRemove;
        if (LOG.isDebugEnabled()) {
            LOG.debug("pruning unimportant entries from RatingTable");
        }
        if ((tokensToRemove = this._tokenMap.size() - 50000) <= 0) {
            return;
        }
        TreeSet<Token> sortedTokens = new TreeSet<Token>(this._tokenMap.values());
        for (Token token : sortedTokens) {
            this._tokenMap.remove(token);
            if (--tokensToRemove != 0) continue;
            break;
        }
    }

    private static File getSpamDat() {
        return new File(CommonUtils.getUserSettingsDir(), "spam.dat");
    }
}

