/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.spam.AddressToken;
import com.limegroup.gnutella.spam.KeywordToken;
import com.limegroup.gnutella.spam.SizeToken;
import com.limegroup.gnutella.spam.Token;
import com.limegroup.gnutella.spam.UrnToken;
import com.limegroup.gnutella.spam.VendorToken;
import com.limegroup.gnutella.spam.XMLKeywordToken;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class Tokenizer {
    private static final Log LOG = LogFactory.getLog(Tokenizer.class);
    private int MIN_KEYWORD_LENGTH = 3;
    private int MAX_KEYWORD_LENGTH = 8;
    private final String KEYWORD_DELIMITERS = " -._+/*()\\,\t";
    private final Provider<IPFilter> ipFilter;

    @Inject
    Tokenizer(Provider<IPFilter> ipFilter) {
        this.ipFilter = ipFilter;
    }

    void initialize(Token token) {
        if (token instanceof AddressToken) {
            ((AddressToken)token).setIpFilter(this.ipFilter);
        }
    }

    public Token[] getTokens(RemoteFileDesc desc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("tokenizing: " + desc);
        }
        HashSet<Token> set = new HashSet<Token>();
        set.addAll(this.getKeywordTokens(desc));
        if (desc.getSHA1Urn() != null) {
            set.add(this.getUrnToken(desc));
        }
        set.add(this.getSizeToken(desc));
        set.add(this.getVendorToken(desc));
        set.add(this.getAddressToken(desc));
        Token[] tokens = new Token[set.size()];
        tokens = set.toArray(tokens);
        return tokens;
    }

    public Token[] getTokens(RemoteFileDesc[] descs) {
        HashSet<Token> set = new HashSet<Token>();
        for (int i = 0; i < descs.length; ++i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("tokenizing: " + descs[i]);
            }
            set.addAll(this.getKeywordTokens(descs[i]));
            if (descs[i].getSHA1Urn() != null) {
                set.add(this.getUrnToken(descs[i]));
            }
            set.add(this.getSizeToken(descs[i]));
            set.add(this.getVendorToken(descs[i]));
            set.add(this.getAddressToken(descs[i]));
        }
        Token[] tokens = new Token[set.size()];
        tokens = set.toArray(tokens);
        return tokens;
    }

    public Token[] getTokens(QueryRequest qr) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("tokenizing: " + qr);
        }
        HashSet<Token> set = new HashSet<Token>();
        set.addAll(this.getKeywordTokens(qr));
        set.addAll(this.getUrnTokens(qr));
        Token[] tokens = new Token[set.size()];
        tokens = set.toArray(tokens);
        return tokens;
    }

    private Token getUrnToken(RemoteFileDesc desc) {
        if (desc.getSHA1Urn() != null) {
            return new UrnToken(desc.getSHA1Urn());
        }
        return null;
    }

    private Set<Token> getUrnTokens(QueryRequest qr) {
        if (qr.getQueryUrns().isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Token> ret = new HashSet<Token>();
        for (URN urn : qr.getQueryUrns()) {
            ret.add(new UrnToken(urn));
        }
        return ret;
    }

    private Token getSizeToken(RemoteFileDesc desc) {
        return new SizeToken(desc.getSize());
    }

    private Token getVendorToken(RemoteFileDesc desc) {
        return VendorToken.getToken(desc.getVendor());
    }

    private Token getAddressToken(RemoteFileDesc desc) {
        return new AddressToken(desc.getInetAddress().getAddress(), desc.getPort(), this.ipFilter);
    }

    private Set<Token> getKeywordTokens(RemoteFileDesc desc) {
        return this.getKeywordTokens(desc.getFileName(), desc.getXMLDocument());
    }

    private Set<Token> getKeywordTokens(QueryRequest qr) {
        return this.getKeywordTokens(qr.getQuery(), qr.getRichQuery());
    }

    private Set<Token> getKeywordTokens(String fname, LimeXMLDocument doc) {
        Set<Token> tokens = this.getKeywordTokens(fname.toLowerCase(Locale.US));
        if (doc != null) {
            for (Map.Entry<String, String> entry : doc.getNameValueSet()) {
                tokens.addAll(this.getXMLKeywords(entry.getKey().toString().toLowerCase(Locale.US), entry.getValue().toString().toLowerCase(Locale.US)));
            }
        }
        return tokens;
    }

    private Set<Token> getXMLKeywords(String name, String value) {
        name = this.extractSimpleFieldName(name);
        HashSet<Token> ret = new HashSet<Token>();
        StringTokenizer tok = new StringTokenizer(value, " -._+/*()\\,\t");
        while (tok.hasMoreTokens()) {
            byte[] token = tok.nextToken().getBytes();
            if (token.length < this.MIN_KEYWORD_LENGTH) continue;
            if (token.length > this.MAX_KEYWORD_LENGTH) {
                token = this.truncateArray(token, this.MAX_KEYWORD_LENGTH);
            }
            ret.add(new XMLKeywordToken(name, token));
        }
        return ret;
    }

    private byte[] truncateArray(byte[] array, int length) {
        byte[] ret = new byte[length];
        System.arraycopy(array, 0, ret, 0, length);
        return ret;
    }

    private byte[] mergeArrays(byte[] array1, byte[] array2) {
        byte[] ret = new byte[array1.length + array2.length + 1];
        System.arraycopy(array1, 0, ret, 0, array1.length);
        ret[array1.length] = 0;
        System.arraycopy(array2, 0, ret, array1.length + 1, array2.length);
        return ret;
    }

    private String extractSimpleFieldName(String canonicalField) {
        int idx1 = canonicalField.lastIndexOf("__");
        int idx2 = canonicalField.lastIndexOf("__", idx1 - 1);
        return canonicalField.substring(idx2 + "__".length(), idx1);
    }

    private Set<Token> getKeywordTokens(String str) {
        HashSet<Token> ret = new HashSet<Token>();
        StringTokenizer tok = new StringTokenizer(str, " -._+/*()\\,\t");
        byte[] last = null;
        while (tok.hasMoreTokens()) {
            KeywordToken token;
            byte[] next = tok.nextToken().getBytes();
            if (next.length < this.MIN_KEYWORD_LENGTH) {
                if (last != null) {
                    token = new KeywordToken(this.mergeArrays(last, next));
                    ret.add(token);
                }
                last = next;
                continue;
            }
            if (next.length > this.MAX_KEYWORD_LENGTH) {
                next = this.truncateArray(next, this.MAX_KEYWORD_LENGTH);
            }
            token = new KeywordToken(next);
            ret.add(token);
            if (last != null) {
                token = new KeywordToken(this.mergeArrays(last, next));
                ret.add(token);
            }
            last = next;
        }
        return ret;
    }
}

