/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.templates;

import java.text.ParseException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StoreTemplateProcessor {
    public static final String ARTIST_LABEL = "artist";
    public static final String ALBUM_LABEL = "album";
    public static final String TITLE_LABEL = "title";
    public static final String TRACK_LABEL = "track";
    protected static final char START_DELIM = '<';
    protected static final char END_DELIM = '>';
    static final int TEMPLATE_PROCESSOR_ILLEGAL_CHARACTER = 0;
    static final int TEMPLATE_PROCESSOR_MISSING_DELIMETER = 1;
    static final int TEMPLATE_PROCESSOR_UNKNOWN_REPLACEMENT = 2;
    static final int TEMPLATE_PROCESSOR_UNCLOSED_VARIABLE = 3;

    protected String performSubstitution(String template, Map<String, String> substitutions) throws IllegalTemplateException {
        StringBuilder outputBuffer = new StringBuilder();
        StringBuilder subBuffer = new StringBuilder();
        States state = States.LOOKING_FOR_START_DELIM;
        for (int i = 0; i < template.length(); ++i) {
            char c = template.charAt(i);
            if (state == States.LOOKING_FOR_START_DELIM) {
                if (c == '<') {
                    state = States.INSIDE_START_DELIM;
                    subBuffer = new StringBuilder();
                    continue;
                }
                outputBuffer.append(c);
                continue;
            }
            if (state != States.INSIDE_START_DELIM) continue;
            if (c == '>') {
                String variable = subBuffer.toString().replaceAll("\\s", "");
                String replacement = substitutions.get(variable);
                if (replacement == null) {
                    throw new IllegalTemplateException(i, 2, template);
                }
                outputBuffer.append(replacement);
                state = States.LOOKING_FOR_START_DELIM;
                continue;
            }
            subBuffer.append(c);
        }
        if (state == States.INSIDE_START_DELIM) {
            throw new IllegalTemplateException(template.length(), 3, template);
        }
        outputBuffer.trimToSize();
        return outputBuffer.toString();
    }

    public static final class IllegalTemplateException
    extends ParseException {
        private final int messageType;
        private final String template;

        public IllegalTemplateException(int pos, int msgType, String template) {
            super("", pos);
            this.messageType = msgType;
            this.template = template;
        }

        public String getMessage() {
            StringBuilder sb = new StringBuilder();
            String s = null;
            try {
                s = super.getMessage();
            }
            catch (Exception e) {
                s = e.getLocalizedMessage();
            }
            sb.append(s);
            sb.append(System.getProperty("line.separator"));
            sb.append(this.template);
            sb.append(System.getProperty("line.separator"));
            int N = this.getErrorOffset();
            for (int i = 0; i < N; ++i) {
                sb.append(' ');
            }
            sb.append('^');
            return sb.toString();
        }

        public String getTemplate() {
            return this.template;
        }

        public int getMessageType() {
            return this.messageType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum States {
        LOOKING_FOR_START_DELIM,
        INSIDE_START_DELIM;

    }
}

