/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.security.MerkleTree;
import com.limegroup.gnutella.security.Tiger;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.tigertree.HashTreeUtils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.Range;
import org.limewire.util.Base32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HashTreeImpl
implements Serializable,
HashTree {
    private static final long serialVersionUID = -5752974896215224469L;
    private static final Log LOG = LogFactory.getLog(HashTreeImpl.class);
    public static final HashTreeImpl INVALID = new HashTreeImpl();
    private final List<byte[]> NODES;
    private final byte[] ROOT_HASH;
    private final long FILE_SIZE;
    private final int DEPTH;
    private final String THEX_URI;
    private transient int _nodeSize;

    private HashTreeImpl() {
        this.NODES = null;
        this.ROOT_HASH = null;
        this.FILE_SIZE = -1L;
        this.DEPTH = -1;
        this.THEX_URI = null;
    }

    HashTreeImpl(List<List<byte[]>> allNodes, String sha1, long fileSize, int nodeSize) {
        this.THEX_URI = "/uri-res/N2X?" + sha1;
        this.NODES = allNodes.get(allNodes.size() - 1);
        this.FILE_SIZE = fileSize;
        this.ROOT_HASH = allNodes.get(0).get(0);
        this.DEPTH = allNodes.size() - 1;
        assert (MerkleTree.log2Ceil(this.NODES.size()) == this.DEPTH);
        assert ((long)this.NODES.size() * (long)nodeSize >= fileSize);
        this._nodeSize = nodeSize;
    }

    @Override
    public boolean isCorrupt(Range in, byte[] data) {
        return this.isCorrupt(in, data, data.length);
    }

    @Override
    public boolean isCorrupt(Range in, byte[] data, int length) {
        assert (in.getHigh() <= this.FILE_SIZE);
        if (in.getLow() % (long)this._nodeSize == 0L && in.getHigh() - in.getLow() + 1L <= (long)this._nodeSize && (in.getHigh() == in.getLow() + (long)this._nodeSize - 1L || in.getHigh() == this.FILE_SIZE - 1L)) {
            MerkleTree digest = new MerkleTree(new Tiger());
            digest.update(data, 0, length);
            byte[] hash = digest.digest();
            byte[] treeHash = this.NODES.get((int)(in.getLow() / (long)this._nodeSize));
            boolean ok = Arrays.equals(treeHash, hash);
            if (LOG.isDebugEnabled()) {
                LOG.debug("interval " + in + " verified " + ok);
            }
            return !ok;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCorrupt(Range in, RandomAccessFile raf, byte[] tmp) {
        assert (in.getHigh() <= this.FILE_SIZE) : "invalid range " + in + " vs " + this.FILE_SIZE;
        if (in.getLow() % (long)this._nodeSize == 0L && in.getHigh() - in.getLow() + 1L <= (long)this._nodeSize && (in.getHigh() == in.getLow() + (long)this._nodeSize - 1L || in.getHigh() == this.FILE_SIZE - 1L)) {
            try {
                int size;
                MerkleTree digest = new MerkleTree(new Tiger());
                for (long read = in.getLow(); read <= in.getHigh(); read += (long)size) {
                    size = (int)Math.min((long)tmp.length, in.getHigh() - read + 1L);
                    RandomAccessFile randomAccessFile = raf;
                    synchronized (randomAccessFile) {
                        raf.seek(read);
                        raf.readFully(tmp, 0, size);
                    }
                    digest.update(tmp, 0, size);
                }
                byte[] hash = digest.digest();
                byte[] treeHash = this.NODES.get((int)(in.getLow() / (long)this._nodeSize));
                boolean ok = Arrays.equals(treeHash, hash);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("interval " + in + " verified " + ok);
                }
                return !ok;
            }
            catch (IOException assumeCorrupt) {
                LOG.debug("iox while verifying ", assumeCorrupt);
                return true;
            }
        }
        return true;
    }

    @Override
    public String httpStringValue() {
        return this.THEX_URI + ";" + Base32.encode(this.ROOT_HASH);
    }

    @Override
    public boolean isGoodDepth() {
        return this.DEPTH == HashTreeUtils.calculateDepth(this.FILE_SIZE);
    }

    @Override
    public boolean isDepthGoodEnough() {
        return this.DEPTH >= HashTreeUtils.calculateDepth(this.FILE_SIZE) - 1;
    }

    @Override
    public boolean isBetterTree(HashTree other) {
        int diff2;
        if (other == null) {
            return true;
        }
        if (other.isGoodDepth()) {
            return false;
        }
        if (this.isGoodDepth()) {
            return true;
        }
        int ideal = HashTreeUtils.calculateDepth(this.FILE_SIZE);
        int diff1 = Math.abs(this.getDepth() - ideal);
        return diff1 < (diff2 = Math.abs(other.getDepth() - ideal));
    }

    @Override
    public long getFileSize() {
        return this.FILE_SIZE;
    }

    @Override
    public String getRootHash() {
        return Base32.encode(this.ROOT_HASH);
    }

    @Override
    public byte[] getRootHashBytes() {
        return this.ROOT_HASH;
    }

    @Override
    public URN getTreeRootUrn() {
        try {
            return URN.createTTRootFromBytes(this.ROOT_HASH);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String getThexURI() {
        return this.THEX_URI;
    }

    @Override
    public int getDepth() {
        return this.DEPTH;
    }

    @Override
    public List<byte[]> getNodes() {
        return this.NODES;
    }

    @Override
    public synchronized int getNodeSize() {
        if (this._nodeSize == 0) {
            this._nodeSize = HashTreeUtils.calculateNodeSize(this.FILE_SIZE, this.DEPTH);
        }
        return this._nodeSize;
    }

    @Override
    public int getNodeCount() {
        double last = this.NODES.size();
        int count = (int)last;
        for (int i = this.DEPTH - 1; i >= 0; --i) {
            last = Math.ceil(last / 2.0);
            count += (int)last;
        }
        return count;
    }
}

