/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.IOException;
import java.util.Locale;

class FileRequestParser {
    FileRequestParser() {
    }

    public static boolean isURNGet(String requestLine) {
        int slash1Index = requestLine.indexOf("/");
        int slash2Index = requestLine.indexOf("/", slash1Index + 1);
        if (slash1Index == -1 || slash2Index == -1) {
            return false;
        }
        String idString = requestLine.substring(slash1Index + 1, slash2Index);
        return idString.equalsIgnoreCase("uri-res");
    }

    public static FileRequest parseTraditionalGet(String uri) throws IOException {
        try {
            int index = -1;
            String fileName = null;
            int g = uri.indexOf("/get/");
            int d = uri.indexOf("/", g + 5);
            String str_index = uri.substring(g + 5, d);
            index = Integer.parseInt(str_index);
            try {
                fileName = URLDecoder.decode(uri.substring(d + 1));
            }
            catch (IllegalArgumentException e) {
                fileName = uri.substring(d + 1);
            }
            return new FileRequest(index, fileName);
        }
        catch (NumberFormatException e) {
            throw new IOException();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException();
        }
    }

    public static FileRequest parseURNGet(FileManager fileManager, String uri) throws IOException {
        RequestType requestType;
        URN urn = URN.createSHA1UrnFromHttpRequest(uri + " HTTP/1.1");
        String requestUpper = uri.toUpperCase(Locale.US);
        if (requestUpper.indexOf("N2X?") > 0) {
            requestType = RequestType.THEX;
        } else if (requestUpper.indexOf("N2R?") > 0) {
            requestType = RequestType.FILE;
        } else {
            return null;
        }
        FileDesc desc = fileManager.getSharedFileDescForUrn(urn);
        if (desc == null) {
            return null;
        }
        return new FileRequest(desc.getIndex(), desc.getFileName(), requestType);
    }

    static class FileRequest {
        String filename;
        int index;
        RequestType requestType;

        public FileRequest(int index, String filename, RequestType requestType) {
            this.index = index;
            this.filename = filename;
            this.requestType = requestType;
        }

        public FileRequest(int index, String filename) {
            this(index, filename, RequestType.FILE);
        }

        public boolean isThexRequest() {
            return this.requestType == RequestType.THEX;
        }

        public String toString() {
            return this.getClass().getName() + " [index=" + this.index + ",filename=" + this.filename + ",type=" + (Object)((Object)this.requestType) + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RequestType {
        FILE,
        THEX;

    }
}

