/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.uploader.HTTPUploadSessionManager;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadSlotManager;
import com.limegroup.gnutella.uploader.UploadSlotUser;
import java.net.InetAddress;
import org.limewire.http.reactor.HttpIOSession;

public class HTTPUploadSession
extends BandwidthTrackerImpl
implements UploadSlotUser {
    public static final int MIN_POLL_TIME = 45000;
    public static final int MAX_POLL_TIME = 120000;
    private HTTPUploader uploader;
    private final InetAddress host;
    private final UploadSlotManager slotManager;
    private volatile long lastPollTime;
    private HTTPUploadSessionManager.QueueStatus queueStatus = HTTPUploadSessionManager.QueueStatus.UNKNOWN;
    private HttpIOSession ioSession;

    public HTTPUploadSession(UploadSlotManager slotManager, InetAddress host, HttpIOSession ioSession) {
        this.slotManager = slotManager;
        this.host = host;
        this.ioSession = ioSession;
    }

    public void setUploader(HTTPUploader uploader) {
        this.uploader = uploader;
    }

    public HTTPUploader getUploader() {
        return this.uploader;
    }

    int positionInQueue() {
        return this.slotManager.positionInQueue(this);
    }

    public String getHost() {
        return this.host.getHostAddress();
    }

    public InetAddress getConnectedHost() {
        return this.host;
    }

    public boolean poll() {
        long now = System.currentTimeMillis();
        return this.lastPollTime + 45000L > now;
    }

    public void releaseSlot() {
        throw new UnsupportedOperationException();
    }

    public void measureBandwidth() {
        HTTPUploader uploader = this.getUploader();
        if (uploader != null) {
            uploader.measureBandwidth();
        }
    }

    public HTTPUploadSessionManager.QueueStatus getQueueStatus() {
        return this.queueStatus;
    }

    public void setQueueStatus(HTTPUploadSessionManager.QueueStatus status) {
        this.queueStatus = status;
        this.updatePollTime(status);
    }

    public boolean canUpload() {
        return this.queueStatus == HTTPUploadSessionManager.QueueStatus.ACCEPTED || this.queueStatus == HTTPUploadSessionManager.QueueStatus.BYPASS;
    }

    public boolean isAccepted() {
        return this.queueStatus == HTTPUploadSessionManager.QueueStatus.ACCEPTED;
    }

    public boolean isQueued() {
        return this.queueStatus == HTTPUploadSessionManager.QueueStatus.QUEUED;
    }

    public void updatePollTime(HTTPUploadSessionManager.QueueStatus status) {
        if (status == HTTPUploadSessionManager.QueueStatus.ACCEPTED || status == HTTPUploadSessionManager.QueueStatus.BYPASS) {
            this.lastPollTime = 0L;
        } else if (status == HTTPUploadSessionManager.QueueStatus.QUEUED) {
            this.lastPollTime = System.currentTimeMillis();
        }
    }

    public HttpIOSession getIOSession() {
        return this.ioSession;
    }

    public String toString() {
        return this.getClass().getName() + "[host=" + this.getHost() + ",queueStatus=" + (Object)((Object)this.queueStatus) + "]";
    }
}

