/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Inject;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PushRequestImpl;
import com.limegroup.gnutella.uploader.HTTPUploadSessionManager;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadType;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.protocol.SimpleNHttpRequestHandler;
import org.apache.http.protocol.HttpContext;
import org.limewire.io.NetworkUtils;
import org.limewire.util.Base32;

public class HttpPushRequestHandler
extends SimpleNHttpRequestHandler {
    private static final Log LOG = LogFactory.getLog(HttpPushRequestHandler.class);
    public static final String P_SERVER_ID = "ServerId";
    public static final String P_GUID = "guid";
    public static final String P_FILE = "file";
    public static final String P_TLS = "tls";
    private HTTPUploadSessionManager sessionManager;
    private MessageRouter messageRouter;

    @Inject
    HttpPushRequestHandler(HTTPUploadSessionManager sessionManager, MessageRouter messageRouter) {
        if (sessionManager == null) {
            throw new IllegalArgumentException();
        }
        if (messageRouter == null) {
            throw new IllegalArgumentException();
        }
        this.sessionManager = sessionManager;
        this.messageRouter = messageRouter;
    }

    public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest request, HttpContext context) throws HttpException, IOException {
        return null;
    }

    public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        HTTPUploader uploader = null;
        HttpPushRequest pushRequest = this.parsePushRequest(request);
        if (pushRequest == null) {
            response.setStatusCode(400);
            uploader = this.sessionManager.getOrCreateUploader(request, context, UploadType.MALFORMED_REQUEST, "Malformed Request");
            uploader.setState(Uploader.UploadStatus.MALFORMED_REQUEST);
        } else {
            uploader = this.sessionManager.getOrCreateUploader(request, context, UploadType.PUSH_PROXY, pushRequest.clientGUID);
            uploader.setState(Uploader.UploadStatus.PUSH_PROXY);
            if (!this.sendRequest(pushRequest)) {
                response.setStatusCode(410);
                response.setReasonPhrase("Servent not connected");
            } else {
                response.setStatusCode(202);
                response.setReasonPhrase("Message sent");
            }
        }
        this.sessionManager.sendResponse(uploader, response);
    }

    private HttpPushRequest parsePushRequest(HttpRequest request) {
        String uri = request.getRequestLine().getUri();
        int i = uri.indexOf(63);
        if (i == -1) {
            return null;
        }
        String queryString = uri.substring(i + 1);
        StringTokenizer t = new StringTokenizer(queryString, "=&");
        if (t.countTokens() < 2 || t.countTokens() % 2 != 0) {
            return null;
        }
        String clientGUID = null;
        int fileIndex = 0;
        boolean useTLS = false;
        while (t.hasMoreTokens()) {
            String key = t.nextToken();
            String val = t.nextToken();
            if (key.equalsIgnoreCase(P_SERVER_ID)) {
                if (clientGUID != null) {
                    return null;
                }
                byte[] base16 = Base32.decode(val);
                if (base16.length != 16) {
                    return null;
                }
                clientGUID = new GUID(base16).toHexString();
                continue;
            }
            if (key.equalsIgnoreCase(P_GUID)) {
                if (clientGUID != null || val.length() != 32) {
                    return null;
                }
                clientGUID = val;
                continue;
            }
            if (key.equalsIgnoreCase(P_FILE)) {
                if (fileIndex != 0) {
                    return null;
                }
                try {
                    fileIndex = Integer.parseInt(val);
                }
                catch (NumberFormatException e) {
                    return null;
                }
                if (fileIndex >= 0) continue;
                return null;
            }
            if (!key.equalsIgnoreCase(P_TLS)) continue;
            useTLS = "true".equalsIgnoreCase(val);
        }
        if (clientGUID == null) {
            return null;
        }
        Header header = request.getLastHeader(HTTPHeaderName.NODE.httpStringValue());
        if (header == null) {
            LOG.info("Missing X-Node header push proxy request");
            return null;
        }
        InetSocketAddress address = this.getNodeAddress(header.getValue());
        if (address == null) {
            LOG.info("Invalid node address for push proxy request: " + header.getValue());
            return null;
        }
        return new HttpPushRequest(clientGUID, fileIndex, address, useTLS);
    }

    private InetSocketAddress getNodeAddress(String value) {
        StringTokenizer t = new StringTokenizer(value, ":");
        if (t.countTokens() == 2) {
            try {
                InetAddress address = InetAddress.getByName(t.nextToken().trim());
                int port = Integer.parseInt(t.nextToken().trim());
                if (NetworkUtils.isValidAddress(address) && NetworkUtils.isValidPort(port)) {
                    return new InetSocketAddress(address, port);
                }
            }
            catch (UnknownHostException badHost) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean sendRequest(HttpPushRequest request) {
        byte[] clientGUID = GUID.fromHexString(request.getClientGUID());
        PushRequestImpl push = new PushRequestImpl(GUID.makeGuid(), 0, clientGUID, request.getFileIndex(), request.getAddress().getAddress().getAddress(), request.getAddress().getPort(), Message.Network.TCP, request.isUseTLS());
        try {
            this.messageRouter.sendPushRequest(push);
        }
        catch (IOException e) {
            LOG.debug("Sending of push proxy request failed", e);
            return false;
        }
        return true;
    }

    private static class HttpPushRequest {
        private String clientGUID;
        private int fileIndex;
        private InetSocketAddress address;
        private boolean useTLS;

        public HttpPushRequest(String clientGUID, int fileIndex, InetSocketAddress address, boolean useTLS) {
            this.clientGUID = clientGUID;
            this.fileIndex = fileIndex;
            this.address = address;
            this.useTLS = useTLS;
        }

        public String getClientGUID() {
            return this.clientGUID;
        }

        public int getFileIndex() {
            return this.fileIndex;
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public boolean isUseTLS() {
            return this.useTLS;
        }
    }
}

