/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.EncodingUtils;
import com.limegroup.gnutella.util.PortableImpl;
import java.io.File;
import java.io.IOException;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.setting.SettingsFactory;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;
import org.limewire.util.VersionUtils;

public final class LimeWireUtils {
    @InspectablePrimitive(value="limewire version")
    private static final String LIMEWIRE_VERSION = "4.18.8";
    @InspectablePrimitive(value="bittorrent revision")
    public static final String BT_REVISION = "0002";
    private static String testVersion = null;
    private static final boolean betaVersion = true;
    private static final boolean alphaVersion = false;
    private static final int _majorVersionNumber = LimeWireUtils.getMajorVersionNumberInternal("4.18.8");
    private static final int _minorVersionNumber = LimeWireUtils.getMinorVersionNumberInternal("4.18.8");
    private static final int _serviceVersionNumber = LimeWireUtils.getServiceVersionNumberInternal("4.18.8");
    private static final int _guessMajorVersionNumber = 0;
    private static final int _guessMinorVersionNumber = 1;
    private static final int _upMajorVersionNumber = 0;
    private static final int _upMinorVersionNumber = 1;
    public static final String QHD_VENDOR_NAME = "LIME";
    private static final String HTTP_SERVER;
    private static final String LIMEWIRE_PREFS_DIR_NAME = ".limewire";
    @InspectablePrimitive(value="pro")
    private static boolean _isPro;
    private static boolean temporaryDirectoryInUse;

    private LimeWireUtils() {
    }

    public static boolean isBetaRelease() {
        return true;
    }

    public static boolean isAlphaRelease() {
        return false;
    }

    public static int getGUESSMajorVersionNumber() {
        return 0;
    }

    public static int getGUESSMinorVersionNumber() {
        return 1;
    }

    public static int getUPMajorVersionNumber() {
        return 0;
    }

    public static int getUPMinorVersionNumber() {
        return 1;
    }

    public static String getLimeWireVersion() {
        if (testVersion == null) {
            return LIMEWIRE_VERSION;
        }
        return testVersion;
    }

    public static int getMajorVersionNumber() {
        return _majorVersionNumber;
    }

    public static int getMinorVersionNumber() {
        return _minorVersionNumber;
    }

    public static int getServiceVersionNumber() {
        return _serviceVersionNumber;
    }

    static int getMajorVersionNumberInternal(String version) {
        if (!version.equals("@version@")) {
            try {
                int firstDot = version.indexOf(".");
                String majorStr = version.substring(0, firstDot);
                return new Integer(majorStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 2;
    }

    public static boolean isPro() {
        return _isPro;
    }

    public static boolean isTestingVersion() {
        return LIMEWIRE_VERSION.equals("@version@");
    }

    static int getMinorVersionNumberInternal(String version) {
        if (!version.equals("@version@")) {
            try {
                int firstDot = version.indexOf(".");
                String minusMajor = version.substring(firstDot + 1);
                int secondDot = minusMajor.indexOf(".");
                String minorStr = minusMajor.substring(0, secondDot);
                return new Integer(minorStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 7;
    }

    static int getServiceVersionNumberInternal(String version) {
        if (!version.equals("@version@")) {
            try {
                int p;
                int q;
                int firstDot = version.indexOf(".");
                int secondDot = version.indexOf(".", firstDot + 1);
                for (q = p = secondDot + 1; q < version.length() && Character.isDigit(version.charAt(q)); ++q) {
                }
                if (p != q) {
                    String service = version.substring(p, q);
                    return new Integer(service);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static String getVendor() {
        return "LimeWire 4.18.8";
    }

    public static String getHttpServer() {
        return HTTP_SERVER;
    }

    public static File getTemporarySettingsDirectory() throws IOException {
        File tempDir = FileUtils.createTempFile("limewire", "-temp").getAbsoluteFile();
        File tempDirParent = tempDir.getParentFile();
        tempDir.delete();
        if (!tempDir.exists() && tempDir.mkdir() && tempDir.exists() && tempDir.isDirectory()) {
            return tempDir;
        }
        for (int i = 0; i < 1000; ++i) {
            tempDir = new File(tempDirParent, "limewire-tempdir-" + i);
            if (tempDir.exists() || !tempDir.mkdir() || !tempDir.exists() || !tempDir.isDirectory()) continue;
            return tempDir;
        }
        throw new IOException("temporary directory failed.  parent [" + tempDirParent + "]");
    }

    public static void clearTemporarySettingsDirectories() {
        File tempDir;
        try {
            tempDir = FileUtils.createTempFile("limewire", "-temp").getAbsoluteFile();
        }
        catch (IOException failure) {
            return;
        }
        File tempDirParent = tempDir.getParentFile();
        tempDir.delete();
        for (int i = 0; i < 1000; ++i) {
            File dir = new File(tempDirParent, "limewire-tempdir-" + i);
            if (dir.delete()) continue;
            FileUtils.deleteRecursive(dir);
        }
    }

    public static File getRequestedUserSettingsLocation() {
        File portableLocation;
        PortableImpl portable = new PortableImpl();
        try {
            portableLocation = !portable.isPortable() ? null : (portable.getSettingsLocation() != null ? portable.getSettingsLocation() : PortableImpl.getDefaultSettingsLocation());
        }
        catch (IOException e) {
            portableLocation = null;
        }
        if (portableLocation != null) {
            return portableLocation;
        }
        File userDir = CommonUtils.getUserHomeDir();
        if (!OSUtils.isPOSIX() && userDir != null && userDir.exists()) {
            FileUtils.setWriteable(userDir);
        }
        File settingsDir = new File(userDir, LIMEWIRE_PREFS_DIR_NAME);
        if (OSUtils.isWindows()) {
            File tempSettingsDir;
            String appdata = System.getProperty("LIMEWIRE_PREFS_DIR", SystemUtils.getSpecialPath(SystemUtils.SpecialLocations.APPLICATION_DATA));
            if (appdata != null && appdata.length() > 0 && ((tempSettingsDir = new File(appdata = LimeWireUtils.stripQuotes(appdata), "LimeWire")).isDirectory() || !settingsDir.exists())) {
                FileUtils.setWriteable(new File(appdata));
                try {
                    CommonUtils.validateSettingsDirectory(tempSettingsDir);
                    return tempSettingsDir;
                }
                catch (IOException e) {
                }
                catch (SecurityException e) {}
            }
        } else if (OSUtils.isMacOSX()) {
            settingsDir = new File(CommonUtils.getUserHomeDir(), "Library/Preferences/LimeWire");
        }
        return settingsDir;
    }

    private static String stripQuotes(String incoming) {
        if (incoming == null || incoming.length() <= 2) {
            return incoming;
        }
        if ((incoming = incoming.trim()).startsWith("\"")) {
            incoming = incoming.substring(1);
        }
        if (incoming.endsWith("\"")) {
            incoming = incoming.substring(0, incoming.length() - 1);
        }
        return incoming;
    }

    public static String addLWInfoToUrl(String url, byte[] myClientGUID) {
        url = url.indexOf(63) == -1 ? url + "?" : url + "&";
        url = url + "guid=" + EncodingUtils.encode(new GUID(myClientGUID).toHexString()) + "&pro=" + LimeWireUtils.isPro() + "&lang=" + EncodingUtils.encode(ApplicationSettings.getLanguage()) + "&lv=" + EncodingUtils.encode(LimeWireUtils.getLimeWireVersion()) + "&jv=" + EncodingUtils.encode(VersionUtils.getJavaVersion()) + "&os=" + EncodingUtils.encode(OSUtils.getOS()) + "&osv=" + EncodingUtils.encode(OSUtils.getOSVersion());
        return url;
    }

    public static boolean isTemporaryDirectoryInUse() {
        return temporaryDirectoryInUse;
    }

    public static boolean hasSettingsLoadSaveFailures() {
        return SettingsFactory.hasLoadSaveFailure();
    }

    public static void setTemporaryDirectoryInUse(boolean inUse) {
        temporaryDirectoryInUse = inUse;
    }

    public static void resetSettingsLoadSaveFailures() {
        SettingsFactory.resetLoadSaveFailure();
    }

    public static File getLimeWireRootFolder() {
        String root = null;
        if (OSUtils.isWindows()) {
            root = SystemUtils.getSpecialPath(SystemUtils.SpecialLocations.DOCUMENTS);
        }
        if (root == null || "".equals(root)) {
            root = CommonUtils.getUserHomeDir().getPath();
        }
        return new File(root, "LimeWire");
    }

    static {
        _isPro = false;
        if (!LIMEWIRE_VERSION.endsWith("Pro")) {
            HTTP_SERVER = "LimeWire/4.18.8";
        } else {
            HTTP_SERVER = "LimeWire/" + LIMEWIRE_VERSION.substring(0, LIMEWIRE_VERSION.length() - 4) + " (Pro)";
            _isPro = true;
        }
    }
}

