/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import org.limewire.service.ErrorService;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public class MacOSXUtils {
    private static final String APP_NAME = "LimeWire.app";

    private MacOSXUtils() {
    }

    public static void setLoginStatus(boolean allow) {
        MacOSXUtils.SetLoginStatusNative(allow);
    }

    public static String getUserName() {
        return MacOSXUtils.GetCurrentFullUserName();
    }

    public static String getAppDir() {
        String appDir = "/Applications/LimeWire/";
        String path = CommonUtils.getCurrentDirectory().getPath();
        int app = path.indexOf(APP_NAME);
        if (app != -1) {
            appDir = path.substring(0, app);
        }
        return appDir + APP_NAME;
    }

    private static final native String GetCurrentFullUserName();

    private static final native void SetLoginStatusNative(boolean var0);

    static {
        if (OSUtils.isMacOSX105()) {
            try {
                System.loadLibrary("MacOSXUtilsLeopard");
            }
            catch (UnsatisfiedLinkError err) {
                ErrorService.error(err);
            }
        } else if (OSUtils.isAnyMac()) {
            try {
                System.loadLibrary("MacOSXUtilsTiger");
            }
            catch (UnsatisfiedLinkError err) {
                ErrorService.error(err);
            }
        }
    }
}

