/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.Portable;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.limewire.util.FileUtils;

public class PortableImpl
implements Portable {
    static final String PORTABLE_FILE = "portable.props";
    static final String PROGRAM_FILE = "limewire.props";
    static final String SOURCE_KEY = "SOURCE";
    static final String SETTINGS_KEY = "SETTINGS";
    static final String DEFAULT_SETTINGS_VALUE = "Settings";
    static final String KEY_PREFIX = "PORTABLE_PATH_";
    private File path;
    private IOException exception;

    public PortableImpl() {
        try {
            File portablePath = new File(PORTABLE_FILE);
            if (!portablePath.exists()) {
                return;
            }
            Properties portableProperties = FileUtils.readProperties(portablePath);
            this.path = FileUtils.resolveSpecialPath(portableProperties.getProperty(SETTINGS_KEY));
            if (portableProperties.containsKey(SOURCE_KEY)) {
                File source = FileUtils.resolveSpecialPath(portableProperties.getProperty(SOURCE_KEY));
                if (!this.path.exists()) {
                    FileUtils.copyDirectory(source, this.path);
                }
            }
            Properties programProperties = new Properties();
            File programPath = new File(this.path, PROGRAM_FILE);
            if (programPath.exists()) {
                programProperties = FileUtils.readProperties(programPath);
            }
            boolean save = false;
            for (String string : portableProperties.keySet()) {
                String key;
                if (!string.startsWith(KEY_PREFIX) || (key = string.substring(KEY_PREFIX.length(), string.length()).trim()).length() == 0) continue;
                String value = FileUtils.resolveSpecialPath(portableProperties.getProperty(string)).getPath();
                programProperties.setProperty(key, value);
                save = true;
            }
            if (save) {
                FileUtils.makeFolder(this.path);
                FileUtils.writeProperties(programPath, programProperties);
            }
        }
        catch (IOException e) {
            this.exception = e;
        }
    }

    public boolean isPortable() {
        return this.path != null || this.exception != null;
    }

    public File getSettingsLocation() {
        return this.path;
    }

    public static File getDefaultSettingsLocation() throws IOException {
        return FileUtils.resolveSpecialPath(DEFAULT_SETTINGS_VALUE);
    }
}

