/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.settings.SearchSettings;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.util.I18NConvert;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryUtils {
    private static final List<String> TRIVIAL_WORDS = Arrays.asList("the", "an", "a", "and");

    public static final Set<String> keywords(String fileName, boolean allowNumbers) {
        fileName = QueryUtils.ripExtension(fileName);
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        String delim = " -._+/*()\\,";
        char[] illegal = SearchSettings.ILLEGAL_CHARS.getValue();
        StringBuilder sb = new StringBuilder(delim.length() + illegal.length);
        sb.append(illegal).append(delim);
        StringTokenizer st = new StringTokenizer(fileName, sb.toString());
        while (st.hasMoreTokens()) {
            String currToken = st.nextToken().toLowerCase();
            if (!allowNumbers) {
                try {
                    Double.valueOf(currToken);
                    continue;
                }
                catch (NumberFormatException normalWord) {
                    // empty catch block
                }
            }
            if (TRIVIAL_WORDS.contains(currToken)) continue;
            ret.add(currToken);
        }
        return ret;
    }

    public static final Set<String> keywords(String fileName) {
        return QueryUtils.keywords(fileName, false);
    }

    public static final String removeIllegalChars(String name) {
        String ret = "";
        String delim = " -._+/*()\\,";
        char[] illegal = SearchSettings.ILLEGAL_CHARS.getValue();
        StringBuilder sb = new StringBuilder(delim.length() + illegal.length);
        sb.append(illegal).append(delim);
        StringTokenizer st = new StringTokenizer(name, sb.toString());
        while (st.hasMoreTokens()) {
            ret = ret + st.nextToken().trim() + " ";
        }
        return ret.trim();
    }

    public static String ripExtension(String fileName) {
        String retString = null;
        int extStart = fileName.lastIndexOf(46);
        retString = extStart == -1 ? fileName : fileName.substring(0, extStart);
        return retString;
    }

    public static String createQueryString(String name, boolean allowNumbers) {
        if (name == null) {
            throw new NullPointerException("null name");
        }
        String retString = null;
        name = I18NConvert.instance().getNorm(name);
        int maxLen = SearchSettings.MAX_QUERY_LENGTH.getValue();
        Set<String> keywords = QueryUtils.keywords(name, allowNumbers);
        if (keywords.isEmpty()) {
            retString = QueryUtils.removeIllegalChars(name);
            retString = StringUtils.truncate(retString, maxLen);
        } else {
            StringBuilder sb = new StringBuilder();
            int numWritten = 0;
            for (String currKey : keywords) {
                if (numWritten >= maxLen) break;
                if (numWritten + currKey.length() >= maxLen) continue;
                if (numWritten > 0) {
                    sb.append(" ");
                    ++numWritten;
                }
                sb.append(currKey);
                numWritten += currKey.length();
            }
            if ((retString = sb.toString()).equals("")) {
                retString = StringUtils.truncate(keywords.iterator().next(), maxLen);
            }
        }
        assert (retString.length() <= maxLen) : "Original filename: " + name + ", converted: " + retString;
        if (!keywords.isEmpty()) assert (!retString.equals("")) : "Original filename: " + name;
        return retString;
    }

    public static String createQueryString(String name) {
        return QueryUtils.createQueryString(name, false);
    }
}

