/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.version;

import java.util.Arrays;
import java.util.Locale;
import java.util.StringTokenizer;
import org.limewire.util.OSUtils;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;

class OS {
    private static final Version STAR;
    private static final Version BAD;
    private final String os;
    private final Version fromVersion;
    private final Version toVersion;
    private final boolean acceptable;

    OS(String s, Version fromVersion, Version toVersion) {
        this.os = s;
        this.fromVersion = fromVersion;
        this.toVersion = toVersion;
        this.acceptable = this.accept(s.toLowerCase(Locale.US));
    }

    public String toString() {
        return this.os;
    }

    public boolean isAcceptable() {
        return this.acceptable;
    }

    static OS[] createFromList(String oses, String versions) {
        int i;
        StringTokenizer st = new StringTokenizer(oses, ",");
        Object[] versionsFrom = new Version[st.countTokens()];
        Object[] versionsTo = new Version[st.countTokens()];
        if (versions != null && versions.length() > 0) {
            StringTokenizer v = new StringTokenizer(versions, ",");
            if (v.countTokens() == st.countTokens() * 2) {
                try {
                    for (i = 0; i < versionsFrom.length; ++i) {
                        String s = v.nextToken().trim();
                        versionsFrom[i] = s.equals("*") ? STAR : new Version(s);
                        s = v.nextToken().trim();
                        versionsTo[i] = s.equals("*") ? STAR : new Version(s);
                    }
                }
                catch (VersionFormatException bad) {
                    Arrays.fill(versionsFrom, BAD);
                    Arrays.fill(versionsTo, BAD);
                }
            } else {
                Arrays.fill(versionsFrom, BAD);
                Arrays.fill(versionsTo, BAD);
            }
        }
        OS[] all = new OS[st.countTokens()];
        i = 0;
        while (st.hasMoreTokens()) {
            all[i] = new OS(st.nextToken().trim(), (Version)versionsFrom[i], (Version)versionsTo[i]);
            ++i;
        }
        return all;
    }

    static boolean hasAcceptableOS(OS[] oses) {
        for (int i = 0; i < oses.length; ++i) {
            if (!oses[i].isAcceptable()) continue;
            return true;
        }
        return false;
    }

    static String toString(OS[] oses) {
        if (oses == null) {
            return "";
        }
        String s = "";
        for (int i = 0; i < oses.length; ++i) {
            s = s + oses[i].toString();
            if (i >= oses.length - 2) continue;
            s = s + ", ";
        }
        return s;
    }

    private boolean accept(String s) {
        String os;
        if (this.fromVersion != null && this.toVersion != null) {
            if (this.fromVersion == BAD || this.toVersion == BAD) {
                return false;
            }
            try {
                Version ours = new Version(OSUtils.getOSVersion());
                if (this.fromVersion != STAR && ours.compareTo(this.fromVersion) < 0) {
                    return false;
                }
                if (this.toVersion != STAR && ours.compareTo(this.toVersion) >= 0) {
                    return false;
                }
            }
            catch (VersionFormatException ignore) {
                // empty catch block
            }
        }
        if (s.equals(os = OSUtils.getOS().toLowerCase(Locale.US))) {
            return true;
        }
        if ("windows".equals(s)) {
            return OSUtils.isWindows();
        }
        if ("mac".equals(s)) {
            return OSUtils.isAnyMac();
        }
        if ("linux".equals(s)) {
            return OSUtils.isLinux();
        }
        if ("unix".equals(s)) {
            return OSUtils.isUnix() && !OSUtils.isLinux();
        }
        if ("other".equals(s)) {
            return !OSUtils.isWindows() && !OSUtils.isAnyMac() && !OSUtils.isUnix() && !OSUtils.isLinux();
        }
        return "*".equals(s);
    }

    static {
        Version b;
        Version star;
        try {
            star = new Version("0");
            b = new Version("0");
        }
        catch (VersionFormatException bad) {
            throw new RuntimeException(bad);
        }
        STAR = star;
        BAD = b;
    }
}

