/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.google.inject.Provider;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.licenses.LicenseFactory;
import com.limegroup.gnutella.licenses.LicenseType;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.XMLParsingUtils;
import com.limegroup.gnutella.xml.XMLStringUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.NameValue;
import org.limewire.util.RPNParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimeXMLDocument
implements RPNParser.StringLookup {
    private static final Log LOG = LogFactory.getLog(LimeXMLDocument.class);
    private static final String XML_ID_ATTRIBUTE = "identifier__";
    private static final String XML_ACTION_ATTRIBUTE = "action__";
    private static final String XML_ACTION_INFO = "addactiondetail__";
    static final String XML_INDEX_ATTRIBUTE = "index__";
    private static final String XML_LICENSE_ATTRIBUTE = "license__";
    private static final String XML_LICENSE_TYPE_ATTRIBUTE = "licensetype__";
    private static final String VERSION_STRING = "internal_version";
    private static final String XML_VERSION_ATTRIBUTE = "internal_version__";
    public static final List<LimeXMLDocument> EMPTY_LIST = Collections.emptyList();
    private static final int CURRENT_VERSION = 3;
    private volatile int hashCode = 0;
    private Map<String, String> fieldToValue = new HashMap<String, String>();
    private String schemaUri;
    private String attributeString;
    private File fileId;
    private String action;
    private String actionDetail;
    private volatile int version;
    private List<String> CACHED_KEYWORDS = null;
    private volatile LicenseType licenseType = LicenseType.NO_LICENSE;
    private final LicenseFactory licenseFactory;
    private final Provider<LimeXMLSchemaRepository> limeXMLSchemaRepository;

    LimeXMLDocument(String xml, LicenseFactory licenseFactory, Provider<LimeXMLSchemaRepository> limeXMLSchemaRepository) throws SAXException, SchemaNotFoundException, IOException {
        this.licenseFactory = licenseFactory;
        this.limeXMLSchemaRepository = limeXMLSchemaRepository;
        if (xml == null || xml.equals("")) {
            throw new SAXException("null or empty string");
        }
        InputSource doc = new InputSource(new StringReader(xml));
        XMLParsingUtils.ParseResult result = XMLParsingUtils.parse(doc);
        if (result.isEmpty()) {
            throw new IOException("No element present");
        }
        if (result.schemaURI == null) {
            throw new SchemaNotFoundException("no schema");
        }
        this.fieldToValue = (Map)result.get(0);
        this.schemaUri = result.schemaURI;
        this.setFields(result.canonicalKeyPrefix);
        if (!this.isValid()) {
            throw new IOException("Invalid XML: " + xml + ", fieldToValue: " + this.fieldToValue + ", attrString: " + this.getAttributeString() + ", schemaURI: " + this.schemaUri);
        }
    }

    LimeXMLDocument(Map<String, String> map, String schemaURI, String keyPrefix, LicenseFactory licenseFactory, Provider<LimeXMLSchemaRepository> limeXMLSchemaRepository) throws IOException {
        this.licenseFactory = licenseFactory;
        this.limeXMLSchemaRepository = limeXMLSchemaRepository;
        if (map.isEmpty()) {
            throw new IllegalArgumentException("empty map");
        }
        this.schemaUri = schemaURI;
        this.fieldToValue = map;
        this.fieldToValue.remove(keyPrefix + XML_ID_ATTRIBUTE);
        this.setFields(keyPrefix);
        if (!this.isValid()) {
            throw new IOException("invalid doc! " + map + " \nschema uri: " + schemaURI);
        }
    }

    LimeXMLDocument(Collection<? extends Map.Entry<String, String>> nameValueList, String schemaURI, LicenseFactory licenseFactory, Provider<LimeXMLSchemaRepository> limeXMLSchemaRepository) {
        this.licenseFactory = licenseFactory;
        this.limeXMLSchemaRepository = limeXMLSchemaRepository;
        if (nameValueList.isEmpty()) {
            throw new IllegalArgumentException("empty list");
        }
        this.schemaUri = schemaURI;
        for (Map.Entry<String, String> entry : nameValueList) {
            this.fieldToValue.put(entry.getKey().trim(), entry.getValue());
        }
        this.scanFields();
        if (!this.isValid()) {
            throw new IllegalArgumentException("Invalid Doc!  nameValueList: " + nameValueList + ", schema: " + schemaURI + ", attributeStrings: " + this.getAttributeString() + ", schemaFields: " + (this.getSchema() != null ? Arrays.asList(this.getSchema().getCanonicalizedFieldNames()) : "n/a"));
        }
    }

    boolean isValid() {
        if (this.schemaUri == null || this.getSchema() == null) {
            return false;
        }
        return this.getAttributeString().length() != 0;
    }

    public int getNumFields() {
        return this.fieldToValue.size();
    }

    public List<String> getKeyWords() {
        if (this.CACHED_KEYWORDS != null) {
            return this.CACHED_KEYWORDS;
        }
        ArrayList<String> retList = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.fieldToValue.entrySet()) {
            String currKey = entry.getKey();
            String val = entry.getValue();
            if (val == null || val.equals("") || this.isIndivisible(currKey)) continue;
            try {
                Double.parseDouble(val);
            }
            catch (NumberFormatException ignored) {
                retList.add(val);
            }
        }
        this.CACHED_KEYWORDS = retList;
        return retList;
    }

    public List<String> getKeyWordsIndivisible() {
        return this.licenseType.getIndivisibleKeywords();
    }

    private boolean isIndivisible(String currKey) {
        return currKey.endsWith(XML_LICENSE_TYPE_ATTRIBUTE);
    }

    public String getSchemaURI() {
        return this.schemaUri;
    }

    public LimeXMLSchema getSchema() {
        return this.limeXMLSchemaRepository.get().getSchema(this.schemaUri);
    }

    public String getSchemaDescription() {
        LimeXMLSchema schema = this.getSchema();
        if (schema != null) {
            return schema.getDescription();
        }
        return LimeXMLSchema.getDisplayString(this.schemaUri);
    }

    public File getIdentifier() {
        return this.fileId;
    }

    public void initIdentifier(File id) {
        this.fileId = id;
    }

    public String getAction() {
        if (this.action == null) {
            return "";
        }
        return this.action;
    }

    public boolean actionDetailRequested() {
        return "true".equalsIgnoreCase(this.actionDetail);
    }

    public Set<Map.Entry<String, String>> getNameValueSet() {
        return this.fieldToValue.entrySet();
    }

    public Set<String> getNameSet() {
        return this.fieldToValue.keySet();
    }

    public Collection<String> getValueList() {
        return this.fieldToValue.values();
    }

    public boolean isLicenseAvailable() {
        return this.licenseType != LicenseType.NO_LICENSE;
    }

    public String getLicenseString() {
        if (this.isLicenseAvailable()) {
            String licenseStringSuffix = LimeXMLDocument.getVerifiableLicenseElement(this.licenseType);
            if (licenseStringSuffix == null) {
                return null;
            }
            for (Map.Entry<String, String> next : this.fieldToValue.entrySet()) {
                String key = next.getKey();
                if (!key.endsWith(licenseStringSuffix)) continue;
                return next.getValue();
            }
        }
        return null;
    }

    private static String getVerifiableLicenseElement(LicenseType type) {
        if (type == LicenseType.CC_LICENSE) {
            return XML_LICENSE_ATTRIBUTE;
        }
        if (type.isDRMLicense()) {
            return XML_LICENSE_TYPE_ATTRIBUTE;
        }
        return null;
    }

    public License getLicense() {
        String license = this.getLicenseString();
        if (license != null) {
            return this.licenseFactory.create(license);
        }
        return null;
    }

    public List<NameValue<String>> getOrderedNameValueList() {
        if (this.getSchema() == null) {
            return Collections.emptyList();
        }
        String[] fNames = this.getSchema().getCanonicalizedFieldNames();
        ArrayList<NameValue<String>> retList = new ArrayList<NameValue<String>>(fNames.length);
        for (int i = 0; i < fNames.length; ++i) {
            String name = fNames[i].trim();
            String value = this.fieldToValue.get(name);
            if (value == null) continue;
            retList.add(new NameValue<String>(name, value));
        }
        return retList;
    }

    public String getValue(String fieldName) {
        return this.fieldToValue.get(fieldName);
    }

    public String getXMLString() {
        StringBuilder fullXML = new StringBuilder();
        LimeXMLDocumentHelper.buildXML(fullXML, this.getSchema(), this.getAttributeString() + "/>");
        return fullXML.toString();
    }

    public String getAttributeStringWithIndex(int i) {
        String attributes = this.getAttributeString();
        return attributes + " index=\"" + i + "\"/>";
    }

    private String getAttributeString() {
        if (this.attributeString == null) {
            this.attributeString = this.constructAttributeString();
        }
        return this.attributeString;
    }

    String getXmlWithVersion() {
        StringBuilder fullXML = new StringBuilder();
        LimeXMLDocumentHelper.buildXML(fullXML, this.getSchema(), this.getAttributeString() + " " + VERSION_STRING + "=\"" + this.version + "\"/>");
        return fullXML.toString();
    }

    boolean isCurrent() {
        return this.version == 3;
    }

    void setCurrent() {
        this.version = 3;
    }

    private String constructAttributeString() {
        List<NameValue<String>> attributes = this.getOrderedNameValueList();
        if (attributes.isEmpty()) {
            return "";
        }
        StringBuilder tag = new StringBuilder();
        String root = this.getSchema().getRootXMLName();
        String type = this.getSchema().getInnerXMLName();
        String canonicalKey = root + "__" + type + "__";
        tag.append("<");
        tag.append(type);
        for (NameValue<String> nv : attributes) {
            String name = XMLStringUtils.getLastField(canonicalKey, nv.getName());
            if (name == null) continue;
            tag.append(" ");
            tag.append(name);
            tag.append("=\"");
            tag.append(LimeXMLUtils.encodeXML(nv.getValue()));
            tag.append("\"");
        }
        return tag.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof LimeXMLDocument)) {
            return false;
        }
        LimeXMLDocument xmlDoc = (LimeXMLDocument)o;
        return (this.schemaUri == null ? xmlDoc.schemaUri == null : this.schemaUri.equals(xmlDoc.schemaUri)) && (this.action == null ? xmlDoc.action == null : this.action.equals(xmlDoc.action)) && (this.actionDetail == null ? xmlDoc.actionDetail == null : this.actionDetail.equals(xmlDoc.actionDetail)) && (this.fieldToValue == null ? xmlDoc.fieldToValue == null : ((Object)this.fieldToValue).equals(xmlDoc.fieldToValue)) && this.version == xmlDoc.version;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            if (this.fieldToValue != null) {
                result = 37 * result + ((Object)this.fieldToValue).hashCode();
            }
            if (this.schemaUri != null) {
                result = 37 * result + this.schemaUri.hashCode();
            }
            if (this.action != null) {
                result = 37 * result + this.action.hashCode();
            }
            if (this.actionDetail != null) {
                result = 37 * result + this.actionDetail.hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        return this.getXMLString();
    }

    private void scanFields() {
        String canonicalKey = this.getCanonicalKey(this.getNameValueSet());
        if (canonicalKey == null) {
            return;
        }
        this.setFields(canonicalKey);
        this.fieldToValue.remove(canonicalKey + XML_INDEX_ATTRIBUTE);
        this.fieldToValue.remove(canonicalKey + XML_ID_ATTRIBUTE);
    }

    private void setFields(String prefix) {
        String versionString;
        this.action = this.fieldToValue.get(prefix + XML_ACTION_ATTRIBUTE);
        this.actionDetail = this.fieldToValue.get(prefix + XML_ACTION_INFO);
        String license = this.fieldToValue.get(prefix + XML_LICENSE_ATTRIBUTE);
        String type = this.fieldToValue.get(prefix + XML_LICENSE_TYPE_ATTRIBUTE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("type: " + type);
        }
        this.licenseType = LicenseType.determineLicenseType(license, type);
        if (this.licenseType == LicenseType.CC_LICENSE) {
            this.fieldToValue.put(prefix + XML_LICENSE_TYPE_ATTRIBUTE, "creativecommons.org/licenses/");
        }
        if (this.licenseType == LicenseType.LIMEWIRE_STORE_PURCHASE) {
            this.fieldToValue.put(prefix + XML_LICENSE_TYPE_ATTRIBUTE, LicenseType.LIMEWIRE_STORE_PURCHASE.toString());
        }
        if ((versionString = this.fieldToValue.get(prefix + XML_VERSION_ATTRIBUTE)) != null) {
            try {
                this.version = Integer.parseInt(versionString);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Set version to: " + this.version);
                }
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Unable to set version", nfe);
                this.version = 3;
            }
        } else {
            this.version = 3;
        }
        this.fieldToValue.remove(prefix + XML_VERSION_ATTRIBUTE);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Fields after setting: " + this.fieldToValue);
        }
    }

    private String getCanonicalKey(Collection<? extends Map.Entry<String, String>> entries) {
        if (entries.isEmpty()) {
            return null;
        }
        Map.Entry<String, String> firstEntry = entries.iterator().next();
        String firstKey = firstEntry.getKey();
        int idx = firstKey.indexOf("__");
        if ((idx = firstKey.indexOf("__", idx + 1)) == -1) {
            return null;
        }
        return firstKey.substring(0, idx + 2);
    }

    @Override
    public String lookup(String key) {
        if (key == null) {
            return null;
        }
        if ("schema".equals(key)) {
            return this.getSchemaDescription();
        }
        if ("numKWords".equals(key)) {
            return String.valueOf(this.getKeyWords().size());
        }
        if ("numKWordsI".equals(key)) {
            return String.valueOf(this.getKeyWordsIndivisible().size());
        }
        if ("numFields".equals(key)) {
            return String.valueOf(this.getNumFields());
        }
        if ("ver".equals(key)) {
            return String.valueOf(this.version);
        }
        if (key.startsWith("field_")) {
            key = key.substring(6, key.length());
            return this.getValue(key);
        }
        return null;
    }

    public LicenseFactory getLicenseFactory() {
        return this.licenseFactory;
    }
}

