/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.google.inject.Provider;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.LicenseType;
import com.limegroup.gnutella.metadata.MetaDataFactory;
import com.limegroup.gnutella.metadata.MetaDataReader;
import com.limegroup.gnutella.metadata.MetaDataWriter;
import com.limegroup.gnutella.metadata.MetaReader;
import com.limegroup.gnutella.metadata.audio.AudioMetaData;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.SerialXml;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IdentityHashSet;
import org.limewire.collection.StringTrie;
import org.limewire.io.IOUtils;
import org.limewire.util.ConverterObjectInputStream;
import org.limewire.util.GenericsUtils;
import org.limewire.util.I18NConvert;
import org.limewire.util.NameValue;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimeXMLReplyCollection {
    private static final Log LOG = LogFactory.getLog(LimeXMLReplyCollection.class);
    private final String schemaURI;
    private final Map<URN, LimeXMLDocument> mainMap;
    private final Map<URN, LimeXMLDocument> oldMap;
    private final Map<String, StringTrie<List<LimeXMLDocument>>> trieMap;
    private boolean dirty = false;
    private final Provider<FileManager> fileManager;
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;
    private final MetaDataFactory metaDataFactory;
    private final MetaDataReader metaDataReader;
    private final File savedDocsDir;

    LimeXMLReplyCollection(String URI2, File path, Provider<FileManager> fileManager, LimeXMLDocumentFactory limeXMLDocumentFactory, MetaDataReader metaDataReader, MetaDataFactory metaDataFactory) {
        this.schemaURI = URI2;
        this.fileManager = fileManager;
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
        this.metaDataReader = metaDataReader;
        this.metaDataFactory = metaDataFactory;
        this.trieMap = new HashMap<String, StringTrie<List<LimeXMLDocument>>>();
        this.mainMap = new HashMap<URN, LimeXMLDocument>();
        this.savedDocsDir = path;
        this.oldMap = this.readMapFromDisk();
    }

    public LimeXMLDocument initialize(FileDesc fd, List<? extends LimeXMLDocument> potential) {
        URN urn = fd.getSHA1Urn();
        LimeXMLDocument doc = null;
        for (LimeXMLDocument limeXMLDocument : potential) {
            if (!limeXMLDocument.getSchemaURI().equals(this.schemaURI)) continue;
            doc = limeXMLDocument;
            break;
        }
        if (doc == null) {
            doc = this.oldMap.get(urn);
        }
        if (doc != null && (doc = this.validate(doc, fd.getFile(), fd)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding old document for file: " + fd.getFile() + ", doc: " + doc);
            }
            this.addReply(fd, doc);
        }
        return doc;
    }

    public LimeXMLDocument createIfNecessary(FileDesc fd) {
        LimeXMLDocument doc = null;
        URN urn = fd.getSHA1Urn();
        if (!this.mainMap.containsKey(urn)) {
            File file = fd.getFile();
            if (!(fd.getLimeXMLDocuments().size() != 0 && LimeXMLUtils.isSupportedMultipleFormat(file) || (doc = this.constructDocument(file)) == null)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding newly constructed document for file: " + file + ", doc: " + doc);
                }
                this.addReply(fd, doc);
            }
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFinished() {
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            if (((Object)this.oldMap).equals(this.mainMap)) {
                this.dirty = false;
            }
            this.oldMap.clear();
        }
    }

    private LimeXMLDocument validate(LimeXMLDocument doc, File file, FileDesc fd) {
        if (!doc.isCurrent()) {
            LimeXMLDocument tempDoc;
            if (LOG.isDebugEnabled()) {
                LOG.debug("reconstructing old document: " + file);
            }
            if ((tempDoc = this.constructDocument(file)) != null) {
                doc = this.update(doc, tempDoc);
            } else {
                doc.setCurrent();
            }
        }
        if (!doc.isValid() && (doc = this.constructDocument(file)) == null) {
            return null;
        }
        if (AudioMetaData.isCorrupted(doc)) {
            doc = AudioMetaData.fixCorruption(doc, this.limeXMLDocumentFactory);
            this.mediaFileToDisk(fd, file.getPath(), doc);
        }
        return doc;
    }

    private LimeXMLDocument update(LimeXMLDocument older, LimeXMLDocument newer) {
        HashMap<String, String> fields = new HashMap<String, String>();
        for (Map.Entry<String, String> next : newer.getNameValueSet()) {
            fields.put(next.getKey(), next.getValue());
        }
        for (Map.Entry<String, String> next : older.getNameValueSet()) {
            if (fields.containsKey(next.getKey())) continue;
            fields.put(next.getKey(), next.getValue());
        }
        ArrayList nameValues = new ArrayList(fields.size());
        for (Map.Entry next : fields.entrySet()) {
            nameValues.add(new NameValue((String)next.getKey(), next.getValue()));
        }
        return this.limeXMLDocumentFactory.createLimeXMLDocument(nameValues, newer.getSchemaURI());
    }

    private LimeXMLDocument constructDocument(File file) {
        if (LimeXMLUtils.isSupportedFormatForSchema(file, this.schemaURI)) {
            try {
                LimeXMLDocument document = this.metaDataReader.readDocument(file);
                if (document.getSchemaURI().equals(this.schemaURI)) {
                    return document;
                }
            }
            catch (IOException ignored) {
                LOG.warn("Error creating document", ignored);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getKeyWords() {
        ArrayList<String> retList = new ArrayList<String>();
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            for (LimeXMLDocument d : this.mainMap.values()) {
                if (this.isLWSDoc(d)) continue;
                retList.addAll(d.getKeyWords());
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getKeyWordsIndivisible() {
        ArrayList<String> retList = new ArrayList<String>();
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            for (LimeXMLDocument d : this.mainMap.values()) {
                if (this.isLWSDoc(d)) continue;
                retList.addAll(d.getKeyWordsIndivisible());
            }
        }
        return retList;
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKeywords(LimeXMLDocument doc) {
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            for (Map.Entry<String, String> entry : doc.getNameValueSet()) {
                List<LimeXMLDocument> allDocs;
                String name = entry.getKey();
                String value = I18NConvert.instance().getNorm(entry.getValue());
                StringTrie<List<LimeXMLDocument>> trie = this.trieMap.get(name);
                if (trie == null) {
                    trie = new StringTrie(true);
                    this.trieMap.put(name, trie);
                }
                if ((allDocs = trie.get(value)) == null) {
                    allDocs = new LinkedList<LimeXMLDocument>();
                    trie.add(value, allDocs);
                }
                allDocs.add(doc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeKeywords(LimeXMLDocument doc) {
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            for (Map.Entry<String, String> entry : doc.getNameValueSet()) {
                String value;
                List<LimeXMLDocument> allDocs;
                String name = entry.getKey();
                StringTrie<List<LimeXMLDocument>> trie = this.trieMap.get(name);
                if (trie == null || (allDocs = trie.get(value = I18NConvert.instance().getNorm(entry.getValue()))) == null) continue;
                allDocs.remove(doc);
                if (allDocs.size() != 0) continue;
                trie.remove(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReply(FileDesc fd, LimeXMLDocument replyDoc) {
        assert (this.getSchemaURI().equals(replyDoc.getSchemaURI()));
        URN hash = fd.getSHA1Urn();
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            this.dirty = true;
            this.mainMap.put(hash, replyDoc);
            if (!this.isLWSDoc(replyDoc)) {
                this.addKeywords(replyDoc);
            }
        }
        fd.addLimeXMLDocument(replyDoc);
    }

    public boolean isLWSDoc(LimeXMLDocument doc) {
        return doc != null && doc.getLicenseString() != null && doc.getLicenseString().equals(LicenseType.LIMEWIRE_STORE_PURCHASE.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            return this.mainMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLDocument getDocForHash(URN hash) {
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            return this.mainMap.get(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<LimeXMLDocument> getMatchingReplies(LimeXMLDocument query) {
        IdentityHashSet matching = null;
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            for (Map.Entry<String, String> entry : query.getNameValueSet()) {
                String value;
                Iterator<List<LimeXMLDocument>> iter;
                String name = entry.getKey();
                StringTrie<List<LimeXMLDocument>> trie = this.trieMap.get(name);
                if (trie == null || !(iter = trie.getPrefixedBy(value = entry.getValue())).hasNext()) continue;
                if (matching == null) {
                    matching = new IdentityHashSet();
                }
                while (iter.hasNext()) {
                    matching.addAll(iter.next());
                }
            }
        }
        if (matching == null || matching.size() == 0) {
            return Collections.emptyList();
        }
        LinkedList<LimeXMLDocument> actualMatches = null;
        for (LimeXMLDocument currReplyDoc : matching) {
            if (!LimeXMLUtils.match(currReplyDoc, query, false)) continue;
            if (actualMatches == null) {
                actualMatches = new LinkedList<LimeXMLDocument>();
            }
            actualMatches.add(currReplyDoc);
        }
        if (actualMatches == null || actualMatches.size() == 0) {
            return Collections.emptyList();
        }
        return actualMatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLDocument replaceDoc(FileDesc fd, LimeXMLDocument newDoc) {
        assert (this.getSchemaURI().equals(newDoc.getSchemaURI()));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Replacing doc in FD (" + fd + ") with new doc (" + newDoc + ")");
        }
        LimeXMLDocument oldDoc = null;
        URN hash = fd.getSHA1Urn();
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            this.dirty = true;
            oldDoc = this.mainMap.put(hash, newDoc);
            assert (oldDoc != null) : "attempted to replace doc that did not exist!!";
            this.removeKeywords(oldDoc);
            if (!this.isLWSDoc(newDoc)) {
                this.addKeywords(newDoc);
            }
        }
        boolean replaced = fd.replaceLimeXMLDocument(oldDoc, newDoc);
        assert (replaced);
        return oldDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDoc(FileDesc fd) {
        LimeXMLDocument val;
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            val = this.mainMap.remove(fd.getSHA1Urn());
            if (val != null) {
                this.dirty = true;
            }
        }
        if (val != null) {
            fd.removeLimeXMLDocument(val);
            this.removeKeywords(val);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("removed: " + val);
        }
        return val != null;
    }

    public MetaDataState mediaFileToDisk(FileDesc fd, String fileName, LimeXMLDocument doc) {
        MetaDataWriter writer;
        MetaDataState writeState = MetaDataState.UNCHANGED;
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing: " + fileName + " to disk.");
        }
        if ((writer = this.getEditorIfNeeded(fileName, doc)) != null) {
            writeState = this.commitMetaData(fileName, writer);
        }
        assert (writeState != MetaDataState.INCORRECT_FILETYPE) : "trying to write data to unwritable file";
        return writeState;
    }

    private MetaDataWriter getEditorIfNeeded(String fileName, LimeXMLDocument doc) {
        if (!LimeXMLUtils.isSupportedEditableFormat(fileName)) {
            return null;
        }
        MetaDataWriter newValues = new MetaDataWriter(fileName, this.metaDataFactory);
        newValues.populate(doc);
        MetaReader existing = null;
        try {
            existing = this.metaDataFactory.parse(new File(fileName));
        }
        catch (IOException e) {
            return null;
        }
        if (!newValues.needsToUpdate(existing.getMetaData())) {
            LOG.debug("tag read from disk is same as XML doc.");
            return null;
        }
        return newValues;
    }

    private MetaDataState commitMetaData(String fileName, MetaDataWriter editor) {
        MetaDataState retVal = editor.commitMetaData();
        if (LOG.isDebugEnabled()) {
            LOG.debug("wrote data: " + (Object)((Object)retVal));
        }
        if (retVal == MetaDataState.FILE_DEFECTIVE || retVal == MetaDataState.RW_ERROR || retVal == MetaDataState.BAD_ID3 || retVal == MetaDataState.INCORRECT_FILETYPE) {
            return retVal;
        }
        this.fileManager.get().fileChanged(new File(fileName));
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeMapToDisk() {
        HashMap<URN, String> xmlMap;
        boolean wrote = false;
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            if (!this.dirty) {
                LOG.debug("Not writing because not dirty.");
                return true;
            }
            xmlMap = new HashMap<URN, String>(this.mainMap.size());
            for (Map.Entry<URN, LimeXMLDocument> entry : this.mainMap.entrySet()) {
                xmlMap.put(entry.getKey(), entry.getValue().getXmlWithVersion());
            }
            this.dirty = false;
        }
        File dataFile = new File(this.savedDocsDir, LimeXMLSchema.getDisplayString(this.schemaURI) + ".sxml2");
        File parent = dataFile.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(dataFile)));
            out.writeObject(xmlMap);
            out.flush();
            wrote = true;
            IOUtils.close(out);
        }
        catch (IOException ignored) {
            LOG.trace("Unable to write", ignored);
        }
        finally {
            IOUtils.close(out);
        }
        return wrote;
    }

    private Map<URN, LimeXMLDocument> readMapFromDisk() {
        File newFile = new File(this.savedDocsDir, LimeXMLSchema.getDisplayString(this.schemaURI) + ".sxml2");
        Map<Object, Object> map = null;
        if (newFile.exists()) {
            map = this.readNewFile(newFile);
        } else {
            File oldFile = new File(this.savedDocsDir, LimeXMLSchema.getDisplayString(this.schemaURI) + ".sxml");
            if (oldFile.exists()) {
                map = this.readOldFile(oldFile);
                oldFile.delete();
            }
        }
        return map == null ? new HashMap() : map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URN, LimeXMLDocument> readNewFile(File input) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading new format from file: " + input);
        }
        ObjectInputStream in = null;
        Map<Object, Object> read = null;
        try {
            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(input)));
            read = GenericsUtils.scanForMap(in.readObject(), URN.class, String.class, GenericsUtils.ScanMode.REMOVE);
        }
        catch (Throwable t) {
            try {
                LOG.error("Unable to read LimeXMLCollection", t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.close(in);
            }
        }
        IOUtils.close(in);
        if (read == null) {
            read = Collections.emptyMap();
        }
        HashMap<URN, LimeXMLDocument> docMap = new HashMap<URN, LimeXMLDocument>(read.size());
        for (Map.Entry<Object, Object> entry : read.entrySet()) {
            try {
                docMap.put((URN)entry.getKey(), this.limeXMLDocumentFactory.createLimeXMLDocument((String)entry.getValue()));
            }
            catch (IOException ignored) {
                LOG.warn("Error creating document for: " + (String)entry.getValue(), ignored);
            }
            catch (SchemaNotFoundException ignored) {
                LOG.warn("Error creating document: " + (String)entry.getValue(), ignored);
            }
            catch (SAXException ignored) {
                LOG.warn("Error creating document: " + (String)entry.getValue(), ignored);
            }
        }
        return docMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URN, LimeXMLDocument> readOldFile(File input) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading old format from file: " + input);
        }
        ConverterObjectInputStream in = null;
        Map<Object, Object> read = null;
        try {
            in = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(input)));
            in.addLookup("com.limegroup.gnutella.xml.LimeXMLDocument", SerialXml.class.getName());
            read = GenericsUtils.scanForMap(in.readObject(), URN.class, SerialXml.class, GenericsUtils.ScanMode.REMOVE);
        }
        catch (Throwable t) {
            try {
                LOG.error("Unable to read LimeXMLCollection", t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.close(in);
            }
        }
        IOUtils.close(in);
        if (read == null) {
            read = Collections.emptyMap();
        }
        HashMap<URN, LimeXMLDocument> docMap = new HashMap<URN, LimeXMLDocument>(read.size());
        for (Map.Entry entry : read.entrySet()) {
            try {
                docMap.put((URN)entry.getKey(), this.limeXMLDocumentFactory.createLimeXMLDocument(((SerialXml)entry.getValue()).getXml(true)));
            }
            catch (IOException ignored) {
                LOG.warn("Error creating document for: " + entry.getValue(), ignored);
            }
            catch (SchemaNotFoundException ignored) {
                LOG.warn("Error creating document: " + entry.getValue(), ignored);
            }
            catch (SAXException ignored) {
                LOG.warn("Error creating document: " + entry.getValue(), ignored);
            }
        }
        return docMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetaDataState {
        UNCHANGED,
        NORMAL,
        FILE_DEFECTIVE,
        RW_ERROR,
        BAD_ID3,
        FAILED_TITLE,
        FAILED_ARTIST,
        FAILED_ALBUM,
        FAILED_YEAR,
        FAILED_COMMENT,
        FAILED_TRACK,
        FAILED_GENRE,
        HASH_FAILED,
        INCORRECT_FILETYPE;

    }
}

