/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLSchemaFieldExtractor;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.limewire.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimeXMLSchema {
    private final List<SchemaFieldInfo> _canonicalizedFields;
    private final String _schemaURI;
    private final String _description;
    private final String _rootXMLName;

    public LimeXMLSchema(URL schemaUrl) throws IOException {
        this(new InputSource(schemaUrl.openStream()));
    }

    public LimeXMLSchema(InputSource inputSource) throws IOException {
        Document document = this.getDocument(inputSource);
        IOUtils.close(inputSource.getByteStream());
        this._canonicalizedFields = Collections.unmodifiableList(new LimeXMLSchemaFieldExtractor().getFields(document));
        this._schemaURI = LimeXMLSchema.retrieveSchemaURI(document);
        this._rootXMLName = LimeXMLSchema.getRootXMLName(document);
        this._description = LimeXMLSchema.getDisplayString(this._schemaURI);
    }

    private Document getDocument(InputSource schemaInputSource) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        documentBuilder.setEntityResolver(new Resolver(schemaInputSource));
        Document document = null;
        try {
            document = documentBuilder.parse(schemaInputSource);
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        return document;
    }

    private static String retrieveSchemaURI(Document document) {
        Element root = document.getDocumentElement();
        NamedNodeMap nnm = root.getAttributes();
        Node targetNameSpaceAttribute = nnm.getNamedItem("targetNamespace");
        if (targetNameSpaceAttribute != null) {
            return targetNameSpaceAttribute.getNodeValue();
        }
        return "";
    }

    private static String getRootXMLName(Document document) {
        Element root = document.getDocumentElement();
        NodeList children = root.getElementsByTagName("element");
        if (children.getLength() == 0) {
            return "";
        }
        Node element = children.item(0);
        NamedNodeMap map = element.getAttributes();
        Node name = map.getNamedItem("name");
        if (name != null) {
            return name.getNodeValue();
        }
        return "";
    }

    public String getSchemaURI() {
        return this._schemaURI;
    }

    public String getRootXMLName() {
        return this._rootXMLName;
    }

    public String getInnerXMLName() {
        return this._description;
    }

    public List<SchemaFieldInfo> getCanonicalizedFields() {
        return this._canonicalizedFields;
    }

    public List<SchemaFieldInfo> getEnumerationFields() {
        LinkedList<SchemaFieldInfo> enumerationFields = new LinkedList<SchemaFieldInfo>();
        for (SchemaFieldInfo schemaFieldInfo : this._canonicalizedFields) {
            if (schemaFieldInfo.getEnumerationList() == null) continue;
            enumerationFields.add(schemaFieldInfo);
        }
        return enumerationFields;
    }

    public String[] getCanonicalizedFieldNames() {
        List<SchemaFieldInfo> canonicalizedFields = this.getCanonicalizedFields();
        String[] fieldNames = new String[canonicalizedFields.size()];
        Iterator<SchemaFieldInfo> iterator = canonicalizedFields.iterator();
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = iterator.next().getCanonicalizedFieldName();
        }
        return fieldNames;
    }

    public String getDescription() {
        return this._description;
    }

    public static String getDisplayString(String schemaURI) {
        int start = schemaURI.lastIndexOf("/");
        int end = schemaURI.lastIndexOf(".");
        String schemaStr = start == -1 || end == -1 ? schemaURI : schemaURI.substring(start + 1, end);
        return schemaStr;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return this._schemaURI.equals(((LimeXMLSchema)o)._schemaURI);
    }

    public int hashCode() {
        return this._schemaURI.hashCode();
    }

    public String toString() {
        return "LimeXMLSchema[description=" + this._description + ", rootXMLName=" + this._rootXMLName + ", schemaURI=" + this._schemaURI + "]";
    }

    private static final class Resolver
    implements EntityResolver {
        private InputSource schema;

        public Resolver(InputSource s) {
            this.schema = s;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            return this.schema;
        }
    }
}

